function CI = within_subject_ci(X)

X = X - repmat(mean(X,2,'omitnan'),1,size(X,2));
[~,~,ci] = ttest(X); % calculate confidence interval assuming a normal distribution
CI = diff(ci)/2*sqrt(size(X,2)/(size(X,2)-1)); % Correction factor as described in Morey (2008)

% CI is half of the confidence interval; so it should be plotted from mean-CI to mean+CI 
% Morey, R. D. (2008). Confidence intervals from normalized data: A correction to Cousineau (2005). Reason, 4, 61-64.


