clear all;close all;clc %#ok<CLALL>
questionnaire_responses % load questionnaire responses

% 1. Baseline
% 2. Virtual fence
% 3. Fixed pedestrian lights
% 4. Pedestrian lights HUD
% 5. Planes on vehicle

Conditions =[1	2	4	5	3 % Matrix of experimental conditions
    5	1	4	3	2
    3	5	2	4	1
    2	4	5	1	3
    4	3	1	2	5
    2	3	1	4	5
    1	4	5	2	3
    5	2	3	1	4
    4	5	2	3	1
    3	1	4	5	2
    2	4	3	1	5
    4	3	5	2	1
    3	5	1	4	2
    1	2	4	5	3
    5	1	2	3	4
    2	1	4	5	3
    1	5	2	3	4
    3	4	5	2	1
    NaN	NaN	NaN	NaN	NaN
    NaN	NaN	NaN	NaN	NaN
    3	1	2	5	4
    5	2	4	1	3
    4	5	1	3	2
    1	4	3	2	5
    1	2	3	5	4
    2	4	5	1	3
    2	3	5	4	1
    3	5	2	4	1
    5	1	4	3	2
    4	3	1	2	5];

%% Read button press data
read_raw=0;
if read_raw==1 % read raw log files containing button press data
    clear AllLogData
    for p=1:30 % loop over 30 participants
        for t=1:30 % loop over 30 trials
            disp(['Read raw data - Participant number: ' num2str(p) ' , Trial number: ' num2str(t)])
            if p==27 % for Participant 27, the filename accidentally contained '25'
                file_of_trial=dir(['Data\Button Press\' num2str(p) '\Log Participant ' num2str(25) ' trial ' num2str(t) ' *.csv']);
            else
                file_of_trial=dir(['Data\Button Press\' num2str(p) '\Log Participant ' num2str(p) ' trial ' num2str(t) ' *.csv']);
            end
            if ~isempty(file_of_trial)
                AllLogData{p,t}=readtable(['Data\Button Press\' num2str(p) '\' file_of_trial.name],'VariableNamingRule','preserve'); %#ok<SAGROW>
            end
        end
    end
    save('AllLogData','AllLogData') % save the data from the log files in a single MAT file
end
load AllLogData % Load the MAT file containing button press data
%% Read intuitiveness scores and post-block interview highlights
if read_raw==2 % read the Excel file with post-trial intuitiveness scores and post-block interview highlights
    IntuitivenessRatings=NaN(30,42);
    for p=1:30
        participant_number=31-p;
        disp(['Read Excel file - Participant number: ' num2str(participant_number)])
        intuitiveness_ratings_of_participant=xlsread('Data\Questionnaires-Interviews\Intuitiveness-Interviews.xlsx',p,'d2:d43'); %#ok<XLSRD>
        if ~isempty(intuitiveness_ratings_of_participant)
            IntuitivenessRatings(participant_number,:)=intuitiveness_ratings_of_participant;
            [~,Interview_highlights(participant_number,:)]=xlsread('Data\Questionnaires-Interviews\Intuitiveness-Interviews.xlsx',p,'e2:e43'); %#ok<dRD,SAGROW>
        end
    end
    IntuitivenessRatings(:,[7     8     9    16    17    18    25    26    27    34    35    36])=[];
    Interview_highlights=Interview_highlights(:,[1 10 19 28 37]);

    save('IntuitivenessRatings','IntuitivenessRatings') % save the data as a MAT file.
    save('Interview_highlights','Interview_highlights') % save the data as a MAT file.
end
load('Interview_highlights')
%% Process the log file into a matrix format, containing numeric data only
AllLogDataNum=NaN(30,30,4645,11); % participant number x trial number x time sample x variable number
for p=1:30 % loop over 30 participants
    for t=1:30 % loop over 30 trials
        datatrial=AllLogData{p,t};
        clear datatrialnum
        if ~isempty(datatrial)
            disp(['Place data in 4D matrix - Participant number: ' num2str(p) ' , Trial number: ' num2str(t)])
            datatrialnum(:,[1 2 4:9])=table2array(datatrial(:,[1 2 4:9]));
            dtArray = datetime(datatrial(:,3).('Date-Time'), 'InputFormat', 'yyyy-MM-dd HH:mm:ss');
            datatrialnum(:,3) = datenum(dtArray); %#ok<DATNM>
            datatrialnum(:,10) = contains(datatrial{:,10},'False')+2*contains(datatrial{:,10},'True');
            datatrialnum(:,11) = contains(datatrial{:,11},'Left')+2*contains(datatrial{:,11},'Middle')+3*contains(datatrial{:,11},'Right');
            AllLogDataNum(p,t,1:size(datatrialnum,1),1:size(datatrialnum,2))=datatrialnum;
        end
    end
end
%% Process questionnaire data
PEQ(:,[10 11 13 14 16 18])=6-PEQ(:,[10 11 13 14 16 18]); % reversal of items of the Van der Laan et al. (1997) acceptance scale
PEQ_other=PEQ(:,[5 6 7]); % items not included in composite score (5. TrustDecision, 6. EarlyLate,  7. SmallLarge)
PEQ(:,[5 6 7])=[]; % remove, as in previous online questionnaire (these items are not part of the composite score)

Composite=zscore(sum(nanzscore(PEQ),2,'omitnan')); % calculate composite score (vector of length 112)
Composite(87)=NaN; % No data for Participant 3, Planes on vehicle
Composite=[Composite(1:28) Composite(29:56) Composite(57:84) Composite(85:112)]; % Virtual fence, Fixed pedestrian lights, Pedestrian lights HUD, Planes on vehicle

PEQ_other=[PEQ_other(1:28,:) PEQ_other(29:56,:) PEQ_other(57:84,:) PEQ_other(85:112,:)];

% 1. Baseline
% 2. Virtual fence
% 3. Fixed pedestrian lights
% 4. Pedestrian lights HUD
% 5. Planes on vehicle

disp(['Mean age: ' num2str(mean(Age,'omitnan'))] )
disp(['SD  age: ' num2str(std(Age,'omitnan'))] )
disp(['Minimum  age: ' num2str(min(Age))] )
disp(['Maximum  age: ' num2str(max(Age))] )

% 1. Participant Number
% 2. Trial Number
% 3. Date, Time
% 4. Time
% 5. PositionX
% 6. PositionY
% 7. PositionZ
% 8. Velocity
% 9. Acceleration
% 10. ButtonPress
% 11. AssetState (position of circle, 1: Left, 2: Middle, 3: Right)
%% Sort the data into per experimental condition (30 participants x 5 AR interfaces x 6 trials per AR interface)

AllLogDataCondition=NaN(30,5,6,4645,11);
AllLogDataPresentationOrder=NaN(30,30,4645,11);
IntuitivenessRatingsCondition=NaN(30,5,6);
CC1=NaN(30,30);
CC2=NaN(30,30);
for p = 1:30 % loop over 30 participants
    for t = 1:30 % loop over 30 trials, in order of presentation
        blocknumber=ceil((t-0.2)/6); % compute the block number (1 to 5) from the trial number
        trialnumberinblock=6-(6*blocknumber-t);
        conditionnumber=Conditions(p,blocknumber); % AR interface number (1 to 5)
        datatrialnum=squeeze(AllLogDataNum(p,t,:,:));

        if ~isnan(datatrialnum(1,1))
            speedtrial=datatrialnum(:,8);
            speedtrial(isnan(speedtrial))=[];
            
            conditionnumber2 = 3*sign(speedtrial(end))+median(datatrialnum(:,11),'omitnan'); % vehicle and circle behavior (1-3: yielding, 4:6: non-yielding) (:,11) contains left, middle, right

            % For Participant 1, Trial 27, no log file was available
            % For participant 4, Block 1, Non-Yielding - Middle was offered twice. Only take the last one.
            % For participant 24, Block 1, Yielding - Left was offered twice. Only take the last one.
            % For participant 30, Trial 19, no log file was available

            CC1(p,t)=conditionnumber; % 1 to 5
            CC2(p,t)=conditionnumber2; % 1-3: yielding, 4-6: non-yielding; 1 & 4: left, 2 & 5: middle, 3 & 6: right

            fi=find(datatrialnum(:,5)>-93.9,1,'first'); % first index of trial, passing the -93.9 m distance threshold
            datatrialnum(1:fi-1,:)=[];
            li=find(isnan(datatrialnum(:,1)),1,'first'); % last index of trial
            datatrialnum(li:end,:)=[];

            datatrialnum(:,4)=datatrialnum(:,4)-datatrialnum(1,4); % correct time index
            AllLogDataCondition(p,conditionnumber,conditionnumber2,1:size(datatrialnum,1),1:size(datatrialnum,2))=datatrialnum;
            AllLogDataPresentationOrder(p,t,1:size(datatrialnum,1),1:size(datatrialnum,2))=datatrialnum;
            IntuitivenessRatingsCondition(p,conditionnumber,conditionnumber2)=IntuitivenessRatings(p,t);
            Interview_highlightsCondition(p,conditionnumber)=Interview_highlights(p,blocknumber);
        end
    end
end
%% Create the button press figure
close all
TL={'Yielding','Non-yielding'};

BPP=NaN(30,2,5); % 30 participants x 2 yielding conditions x 5 AR interfaces. Button press percentage (BPP)

time=0.02:0.02:4645/50;
f=figure;
set(f, 'Renderer', 'painters');

t=tiledlayout(1,2);
t.TileSpacing='normal';
t.Padding='tight';
for c3=[2 1] % non-yielding, yielding
    nexttile
    for c1=1:5 % 5 AR interface conditions
        if c3==1 % yielding condition
            c2=1:3; % 3 trials
        elseif c3==2 % non-yielding condition
            c2=4:6; % 3 trials
        end
        v=10; % variable 10: button press

        x=squeeze(AllLogDataCondition(:,c1,c2,:,v));
        if v==10
            x=(x-1)*100; % convert to a percentage
        end
        x=squeeze(mean(x,2,'omitnan')); % take the average across 3 trials of condition

        if c3==1 % if yielding AV
            BPP(:,1,c1)=mean(x(:,155:388),2,'omitnan')'; % time interval from the onset of the AR interface to the moment the car comes to a standstill
        elseif c3==2 % if non-yielding AV
            BPP(:,2,c1)=mean(x(:,155:326),2,'omitnan')'; % time interval from the onset of the AR interface to the moment to car passes
        end
        title(TL(c3))
        stairs(time,mean(x,'omitnan'),'Linewidth',3);hold on
        grid on
        if v==10
            set(gca,'xlim',[0 10],'ylim',[0 80])
        end
    end
    legend('Baseline','Virtual fence','Fixed pedestrian lights','Pedestrian lights HUD','Planes on vehicle','location','northwest','autoupdate','off')
    ylabel('Percentage of trials');
    xlabel('Elapsed time (s)')
    fig=gcf;
    set(findall(fig,'-property','FontName'),'FontName','Arial','Fontsize',28)
    set(gca,'LooseInset', [0.01 0.01 0.01 0.01])
    %set(gca,'xtick',[1 5:5:100]); set(gca,'ylim',[0 8.1]); set(gca,'xlim',[.5 length(eigr)+.5])
    set(gca,'TickDir','out')
    f.WindowState = 'maximized';
    if c3==1 % yielding
        a = fill([3.1; 7.77; 7.77; 3.1],[-100; -100; 200; 200],[220/255 220/255 220/255]);
    elseif c3==2 % non-yielding
        a = fill([3.1; 6.53; 6.53; 3.1],[-100; -100; 200; 200],[220/255 220/255 220/255]);
    end
    uistack(a,'bottom');
    Ax = gca;
    Ax.YGrid = 'on';
    Ax.Layer = 'top';
end

%% Table 1. Results of repeated-measures ANOVAs for the AR interface comparisons shown in Figure 8.
pvalues=[];tstats=[];dfs=[];
MatrixforAnova=squeeze(BPP([1:18 21:30],2,:));
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Button press percentage - non-yielding (%)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
paired_ttests

MatrixforAnova=squeeze(BPP([1:18 21:30],1,:));
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Button press percentage - yielding (%)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
paired_ttests

MatrixforAnova=Composite([1:2 4:28],:);
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Composite score (z-score)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
MatrixforAnova=Composite; % include Participant 3 in the pairwise comparisons
paired_ttests

MatrixforAnova=mean(IntuitivenessRatingsCondition([1:18 21:30],:,4:6),3,'omitnan');
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Intuitiveness - non-yielding (1 to 7)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
paired_ttests

MatrixforAnova=mean(IntuitivenessRatingsCondition([1:18 21:30],:,1:3),3,'omitnan');
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Intuitiveness - yielding (1 to 7)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
paired_ttests

MatrixforAnova=Rank;
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Preference rank (1: best to 5: worst)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
paired_ttests

MatrixforAnova=PEQ_other([1:2 4:28],1:3:12);
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Trust (1 to 7)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
MatrixforAnova=PEQ_other(:,1:3:12); % include Participant 3 in the pairwise comparisons
paired_ttests

MatrixforAnova=PEQ_other([1:2 4:28],2:3:12);
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Timing (1 to 7)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
MatrixforAnova=PEQ_other(:,2:3:12); % include Participant 3 in the pairwise comparisons
paired_ttests

MatrixforAnova=PEQ_other([1:2 4:28],3:3:12);
[~,table,~]=anova2(MatrixforAnova,1,"off");
disp('Repeated-measures ANOVA "Size (1 to 7)" as a function of condition:  df1, df2, F, p, partial eta squared')
disp([cell2mat(table(2,3)) cell2mat(table(4,3)) cell2mat(table(2,5)) cell2mat(table(2,6)) cell2mat(table(2,2))./(cell2mat(table(2,2))+cell2mat(table(4,2)))])
MatrixforAnova=PEQ_other(:,3:3:12); % include Participant 3 in the pairwise comparisons
paired_ttests

disp('p-values of all post-hoc tests')
disp([squeeze(pvalues(:,1,2:5)) squeeze(pvalues(:,2,3:5)) squeeze(pvalues(:,3,4:5)) squeeze(pvalues(:,4,5))])

disp('t-statistics of all post-hoc tests')
disp([squeeze(tstats(:,1,2:5)) squeeze(tstats(:,2,3:5)) squeeze(tstats(:,3,4:5)) squeeze(tstats(:,4,5))])

disp('df of all post-hoc tests')
disp([squeeze(dfs(:,1,2:5)) squeeze(dfs(:,2,3:5)) squeeze(dfs(:,3,4:5)) squeeze(dfs(:,4,5))])

%% Figure 8. Means and 95% confidence intervals of participants (a) button press percentage for non-yielding AVs (%), (b) button press percentage for yielding AVs (%), (c) composite scores based on post-experiment self-reports (z-score), (d) post-trial intuitiveness scores for non-yielding AVs (1: fully disagree, 7: fully agree), (e) post-trial intuitiveness scores for yielding AVs (1: fully disagree, 7: fully agree), (f) preference ranking (1: most preferred, 5: least preferred), (g) trust for decision-making (1: fully disagree, 7: fully agree), (h) interface trigger timing (1: too early, 7: too late), and (i) interface size (1: too small, 7: too large).
Labels={'1. Baseline','2. Virtual fence','3. Fixed ped. lights','4. Ped. lights HUD','5. Planes on vehicle'};
Ylabel={'Button - non-yielding (%)','Button - yielding (%)',...
    'Composite (z-score)','Intuitive - non-yielding (1 to 7)', 'Intuitive - yielding (1 to 7)', ...
    'Preference rank (1 to 5)','Trust (1 to 7)','Timing (1 to 7)','Size (1 to 7)'};
abcdefghi={'(a)','(b)','(c)','(d)','(e)','(f)','(g)','(h)','(i)'};
M=[mean(squeeze(BPP(:,2,:)),'omitnan')' mean(squeeze(BPP(:,1,:)),'omitnan')'   [NaN;mean(Composite,'omitnan')'] ...
    mean(mean(IntuitivenessRatingsCondition(:,:,4:6),3,'omitnan'),'omitnan')' mean(mean(IntuitivenessRatingsCondition(:,:,1:3),3,'omitnan'),'omitnan')' ...
    mean(Rank)',[NaN;mean(PEQ_other(:,1:3:12),'omitnan')'],[NaN;mean(PEQ_other(:,2:3:12),'omitnan')'],[NaN;mean(PEQ_other(:,3:3:12),'omitnan')']];
CI=[within_subject_ci(squeeze(BPP(:,2,:)))' within_subject_ci(squeeze(BPP(:,1,:)))' [NaN;within_subject_ci(Composite)'] ...
    within_subject_ci(mean(IntuitivenessRatingsCondition(:,:,4:6),3,'omitnan'))' within_subject_ci(mean(IntuitivenessRatingsCondition(:,:,1:3),3,'omitnan'))' ...
    within_subject_ci(Rank)',[NaN;within_subject_ci(PEQ_other(:,1:3:12))'],[NaN;within_subject_ci(PEQ_other(:,2:3:12))'],[NaN;within_subject_ci(PEQ_other(:,3:3:12))']];

POS=[0.045 0.74 0.27 0.25;
    0.385 0.74 0.27 0.25;
    0.72 0.74 0.27 0.25;
    0.045 0.44 0.27 0.25;
    0.385 0.44 0.27 0.25;
    0.72 0.44 0.27 0.25;
    0.045 0.14 0.27 0.25;
    0.385 0.14 0.27 0.25;
    0.72 0.14 0.27 0.25];

f=figure;
set(f, 'Renderer', 'painters');
for i=1:9 % loop over 9 variables
    subplot(3,3,i)
    b=bar(M(:,i));

    hold on
    errorbar(1:5,M(:,i),CI(:,i),'ko','Linewidth',3)

    if ismember(i,7:9)
        set(gca,'xticklabel',Labels)
    else
        set(gca,'xticklabel','')
    end
    set(gca,'ticklength',[0.02 0.02])
    set(gca,'pos',POS(i,:))
    ylabel(Ylabel(i))
    set(gca,'TickDir','out')
    set(gca,'xlim',[0.3 5.7])
    if ismember(i,1)
        set(gca,'ylim',[0 35])
    elseif ismember(i,2)
        set(gca,'ylim',[25 65])
    elseif ismember(i,3)
        set(gca,'ylim',[-0.9 0.7])
    elseif ismember(i,6)
        set(gca,'ylim',[1 5])
    elseif ismember(i,[4 5 7:9])
        set(gca,'ylim',[1 7])
    end
    grid on
    text(0.015, 0.92, abcdefghi(i), 'Units', 'normalized','fontweight','bold','fontname','arial','color','m','fontsize',26)

    for i2=1:5 % loop over 5 AR conditions
        indices = find(squeeze(pvalues(i,i2,:)) < 0.005); % find p-values below the critical value
        stringArray = arrayfun(@num2str, indices, 'UniformOutput', false);
        paired_comparisons = strjoin(stringArray, ' '); % create a string out of it
        ax = gca; % get current axes
        yLim = ax.YLim; % get the y-axis limits
        yRange = yLim(2) - yLim(1); % calculate the range of y values

        % Convert the normalized y-coordinate to a data unit y-coordinate
        normalizedY = 0.05; % this is the normalized y-coordinate
        dataUnitY = yLim(1) + normalizedY * yRange; % convert to data units

        text(i2,dataUnitY,paired_comparisons,'color','g','Fontweight','bold','HorizontalAlignment','center');
    end
end
f.WindowState = 'maximized';
set(gca,'TickDir','out','LooseInset',[0.01 0.01 0.01 0.01])
h=findobj('FontName','Helvetica'); set(h,'FontSize',18,'Fontname','Arial')
