# -*- coding: utf-8 -*-
"""
Created on Wed Sep  8 13:13:55 2021

@author: jeroenverhagen
"""

import os
import pandas as pd
import numpy as np 
import matplotlib.pyplot as plt
import os 

from matplotlib.ticker import MaxNLocator

# %% Settings

tolerance = 1.01 #Actually 3% tolerance of constraint violation in model. Makes a difference in line 107.

output_dir = '../../Highhydrogen_3_10_2021/'
projectnames = os.listdir(output_dir)

if '.DS_Store' in projectnames:
    idx = projectnames.remove('.DS_Store')
if 'Images' in projectnames:
    idx = projectnames.remove('Images')
    
neighbourhoods = os.listdir(output_dir+projectnames[0])
if '_Data_analysis' in neighbourhoods:
    idx = neighbourhoods.remove('_Data_analysis') 
if '.DS_Store' in neighbourhoods:
    idx = neighbourhoods.remove('.DS_Store') 


for p in projectnames:
     for nb in neighbourhoods:
         
         for pw_e in range(-1,2):    
             for pw_i in range(-1,2):
                pathway_id = '/E' + str(pw_e) +'_I'+ str(pw_i)
                datafolder = output_dir+p+'/'+nb+pathway_id  
                
                active_technologies = pd.read_excel(datafolder + '/neigbourhood_active_technology.xlsx')
                active_technologies = active_technologies.to_numpy()
                active_technologies = active_technologies[:,1:]
                active_technologies = active_technologies.flatten()
                
                possible_technologies = pd.read_excel(datafolder + '/emission_by_technology.xlsx')
                possible_technologies = possible_technologies.to_numpy()
                possible_technologies = 1*(np.sum(possible_technologies[:,1:],axis=0)>0)
                possible_technologies = possible_technologies.flatten()
                
                annual_emission = pd.read_excel(datafolder + '/annual_emissions.xlsx')
                annual_emission = annual_emission.to_numpy()
                annual_emission = annual_emission[:,1:]
                
                emission_by_technology = pd.read_excel(datafolder + '/emission_by_technology.xlsx')
                emission_by_technology = emission_by_technology.to_numpy()
                emission_by_technology = emission_by_technology[1:,1:]
                
                heating_strategy = pd.read_excel(datafolder + '/heating_strategy.xlsx')
                heating_strategy = heating_strategy.to_numpy()
                heating_strategy = heating_strategy[:,1:]
                heating_strategy = np.round(heating_strategy)
                
                insulation_level = pd.read_excel(datafolder + '/insulation_level.xlsx')
                insulation_level = insulation_level.to_numpy()
                insulation_level = insulation_level[:,1:]
                
                heat_supply_boundary = pd.read_excel(datafolder + '/heat_supply_boundary.xlsx')
                heat_supply_boundary = heat_supply_boundary.to_numpy()
                heat_supply_boundary = heat_supply_boundary[:,1:]
                
                heat_supply_threshold = pd.read_excel(datafolder + '/heat_supply_threshold.xlsx')
                heat_supply_threshold = heat_supply_threshold.to_numpy()
                heat_supply_threshold = heat_supply_threshold[:,1:]
                heat_supply_threshold[heat_supply_threshold == 1] = 0
                
                address_by_neighborhood_information = pd.read_excel(datafolder + '/address_by_neighborhood_information.xlsx')
                address_by_neighborhood_information = address_by_neighborhood_information.to_numpy()
                address_by_neighborhood_information = address_by_neighborhood_information[:,1:]
                
                period_emission = np.sum(annual_emission,0)
                address_area = address_by_neighborhood_information[:,4]
                
                temp = period_emission.argsort()
                technology_rank = np.empty_like(temp)
                technology_rank[temp] = np.arange(len(period_emission))
                active_technology_sort = np.flip(np.sort(technology_rank[possible_technologies==1]))

                for s in range(0,len(active_technology_sort)-1):
                    
                    address_by_technology = np.where(heating_strategy[:,technology_rank == active_technology_sort[s]])[0]
                    address_savings_matrix = np.zeros((address_by_technology.shape[0],len(active_technology_sort)-s-1))
                    for a in range(0,len(address_by_technology)):
                        
                        #check if the lower emission technologies can be used 
                        for q in range(s+1,len(active_technology_sort)):
                            strategy_feasibility = insulation_level[address_by_technology[a],:] <= heat_supply_boundary[technology_rank == active_technology_sort[q]] + 1e-6
                            
                            if strategy_feasibility.all():
                                emission_difference = emission_by_technology[:,technology_rank == active_technology_sort[s]] - emission_by_technology[:,technology_rank == active_technology_sort[q]] 
                                heat_demand_avg = 0.5*(insulation_level[address_by_technology[a],0:-1] + insulation_level[address_by_technology[a],1:])
                                address_savings_matrix[a,q-s-1] = np.sum(address_area[address_by_technology[a]]*heat_demand_avg*emission_difference)
                        
                    address_savings_matrix_max = np.max(address_savings_matrix,1) 
                    remaining_address_technology = address_by_technology[address_savings_matrix_max == 0]
                    change_address_technology = np.column_stack((address_by_technology[address_savings_matrix_max > 0],address_savings_matrix_max[address_savings_matrix_max > 0],address_savings_matrix[address_savings_matrix_max > 0,:]))
                    change_address_technology = change_address_technology[np.argsort(change_address_technology[:, 1])]

  
                    neighbourhood_heat_demand = np.sum(insulation_level[remaining_address_technology,-1:]*address_area[remaining_address_technology].reshape(len(remaining_address_technology),1))
                    
                    while neighbourhood_heat_demand*tolerance < heat_supply_threshold[technology_rank == active_technology_sort[s]]:
                        neighbourhood_heat_demand = neighbourhood_heat_demand + insulation_level[int(change_address_technology[0,0]),-1:]*address_area[int(change_address_technology[0,0])]
                        change_address_technology = change_address_technology[1:,:]
                        
                    for q in range(0,len(active_technology_sort)-s-1):     
                        
                        strategy_change = change_address_technology[change_address_technology[:,1]==change_address_technology[:,2+q],0]
                        for a in strategy_change:
                            heating_strategy[int(a),technology_rank == active_technology_sort[s+q+1]] = 1
                            heating_strategy[int(a),technology_rank == active_technology_sort[s]] = 0
                
                    
                heat_demand_avg = 0.5*(insulation_level[:,0:-1] + insulation_level[:,1:])                    
                address_emission = 5*address_area*heat_demand_avg.T*np.matmul(emission_by_technology,heating_strategy.T)
                       
                heating_strategy = pd.DataFrame(heating_strategy)
                address_emission = pd.DataFrame(address_emission)
                
                #Remove existing files
                if datafolder +'/heating_strategy_update.xlsx' in os.listdir(datafolder):
                    os.remove(datafolder +'/heating_strategy_update.xlsx')
                if datafolder +'/address_emission_update.xlsx' in os.listdir(datafolder):
                    os.remove(datafolder +'/address_emission_update.xlsx')
                  
                #Save new files
                heating_strategy.to_excel(datafolder +'/heating_strategy_update.xlsx')    
                address_emission.to_excel(datafolder +'/address_emission_update.xlsx')
    