require(tidyverse)
require(ggplot2)
load(file.path("data","processed","biom_pe.Rdata"))
pdf(file.path("output","trends_by_ecotopes.pdf"))
biom_pd<-biom_pe
biom_pd$geometry<-NULL
biom_pd<-as.data.frame(biom_pd)

# simplify ecotopes
biom_pd<- biom_pd %>%
  filter(!grepl("Hard",verkort))%>%
  filter(!grepl("chor",verkort))%>%
  filter(!grepl("upralitoraal",verkort))%>%
  mutate(verkort=sub("hooglitoraal","4hooglitoraal",verkort))%>%
  mutate(verkort=sub("middenlitoraal","3middenlitoraal",verkort))%>%
  mutate(verkort=sub("laaglitoraal","2laaglitoraal",verkort))%>%
  mutate(verkort=sub("sublitoraal","1sublitoraal",verkort))%>%
  mutate(verkort=sub(" litoraal"," 5litoraal",verkort))%>%
  mutate(group=paste(zout,verkort))


gs<-unique(biom_pd$group)
gs<-gs[order(gs)]
gs<-paste0(substr(gs,1,19),substr(gs,21,100))
biom_pd$group<-paste0(substr(biom_pd$group,1,19),substr(biom_pd$group,21,100))

for(i in 1:length(gs)){
  tit<-as.character(gs[i])
  tt<-biom_pd %>% 
    filter(group==gs[i] & monsterjaar>2008)
# plot of means and standard errors, with same loess smoother
  ttt<-tt%>%
    group_by(monsterjaar)%>%
    summarize(mn=mean(sumbiom),sds=sd(sumbiom),n=n())%>%
    mutate(se=sds/sqrt(n))
  ll<-loess(sumbiom~monsterjaar,tt)
  predll<-predict(ll,seq(2009,2020,by=0.1),se=T)
  lin<-data.frame(x=seq(2009,2020,by=0.1),
                  y=predll$fit,
                  ymin=predll$fit-predll$se.fit,
                  ymax=predll$fit+predll$se.fit)
  lims<-c(0,ifelse(grepl("sub",tit),200,60))

  p<-ggplot()+
    scale_y_continuous(limits=lims)+
    geom_point(ttt,mapping=aes(x=monsterjaar,y=mn))+
    geom_errorbar(ttt,mapping=aes(x=monsterjaar,ymin=mn-se,ymax=mn+se))+
    geom_line(lin,mapping=aes(x=x,y=y),color='blue',lwd=1)+
    geom_ribbon(lin,mapping=aes(x=x,ymin=ymin,ymax=ymax),
                alpha=0.1, linetype="dashed",color="grey")+
    ggtitle(tit)+xlab("Jaar")+ylab("Totale Biomassa")+
    theme(text = element_text(size = 20),plot.title=element_text(size=25))
  print(p)

}
dev.off()

