require(tidyverse)
require(sf)
require(lwgeom)
library("ggplot2")

etkj<-c(1996,2001,2004,2008,2010,2011,2012,2015,2016,2018,2020)
theme_set(theme_bw())

load(file.path("./data/processed","wsnew.Rdata"))
pdf(file.path("./output","kaartjes.pdf"), width=12,height=6)

# calculate total biomass per sample
tbs <- wsnew %>%
  filter(seizoen=="Najaar")%>%
  group_by(monster_id,rd_x,rd_y,zout,positie,dynamiek,diepte_hoo, jaar)%>%
  summarise(sumbiom=sum(biomassa_mg_m2,na.rm=T)/1000) %>% 
  mutate(log10biom=ifelse(log10(sumbiom)> (-2),log10(sumbiom),-2))
for (j in 1992:2020){
  tbsj<-tbs %>% filter(jaar==j)%>%mutate(monsterjaar=jaar)%>%select(-jaar,-zout)
  sfje<-st_as_sf(x=tbsj,coords=c("rd_x","rd_y"),crs=st_crs(28992))
  
  etk<-etkj[which(abs(j-etkj)==min(abs(j-etkj)))[1]]
  fil<-paste0("./ecotopenkaart/ecotopenkaart_westerschelde_",etk,"/ecotopenkaart_westerschelde_",etk,
              "Polygon.shp")
  shp<-st_read(fil) 
  
  intsct<-st_intersection(shp,sfje)
  if(j==1992)intsct_all<-intsct else intsct_all<-rbind(intsct_all,intsct)
  
  p<- ggplot(data=shp)+
    geom_sf(aes(fill=verkort))+
    ggtitle(paste(j))+
    geom_sf(data=sfje,aes(color=log10biom,size=1.5))+scale_colour_viridis_c(limits=c(-2,3) )
  print(p)
  
  #   plot(tbsj$rd_x,tbsj$rd_y,pch=21,cex=sqrt(tbsj$sumbiom),asp=1,main=j,xlim=c(25000,80000),lwd=2,
# #       col=ss[pmax(1,floor(log(tbsj$sumbiom)+5))],
#        ylim=c(365000,390000))
}
dev.off()

biom_pe<-intsct_all %>% mutate(ecotoopjaar=jaar) %>%select(-jaar,-zout.1)
save(biom_pe,file=file.path("data","processed","biom_pe.Rdata"))
write_csv(biom_pe,file=file.path("data","processed","biom_pe.csv"))
