require(tidyverse)
require(sf)
for(etk in c(1996,2001,2004,2008,2010,2011,2012,2015,2016,2018,2020)){
  fil<-paste0("./ecotopenkaart/ecotopenkaart_westerschelde_",etk,"/ecotopenkaart_westerschelde_",etk,
              "Polygon",".shp")
  shp<-st_read(fil) 
  for(i in 1:nrow(shp)){
    cd<-st_coordinates(shp[i,])
    onder<-ifelse(cd[,1]>60000&cd[,2]<(379000+cd[,1]-60000),1,0)
    shp$zout[i]<-ifelse(mean(onder)<0.1,'zout','brak')
  }
  if(max(shp$oppervlak)>1000){
    shp$oppervlak<-shp$oppervlak/1e6
    st_write(shp,dsn=fil,append=F)
  }
}

for(etk in c(1996,2001,2004,2008,2010,2011,2012,2015,2016,2018,2020)){
  fil<-paste0("./ecotopenkaart/ecotopenkaart_westerschelde_",etk,"/ecotopenkaart_westerschelde_",etk,
              "Polygon",".shp")
  shp<-st_read(fil) 
  shp$geometry<-NULL
  shpsum<-shp%>%
    group_by(verkort,zout)%>%
    summarise(opp=sum(oppervlak))%>%
    mutate(jaar=etk)
  if(etk==1996)shpsum_all<-shpsum else (shpsum_all<-rbind(shpsum_all,shpsum))
}
save(shpsum_all,file=file.path("data","processed","shpsum_all.Rdata"))
write_csv(shpsum_all,file=file.path("data","processed","shpsum_all.csv"))
