# Inverse-designed Growth-based Metamaterials

This repository contains the dataset to train the deep learning framework for inverse-designing growth-based cellular metamaterials. The machine learning codes can be found here: https://github.com/mmc-group/inverse-designed-growth-based-metamaterials 

Please follow the publication https://doi.org/10.1016/j.mechmat.2023.104668 for further implementation details.

## Citation

If you use this dataset please cite the following publication: Sikko van ’t Sant, Prakash Thakolkaran, Jonàs Martínez, Siddhant Kumar, Inverse-designed growth-based cellular metamaterials, Mechanics of Materials, 2023, 104668, ISSN 0167-6636, https://doi.org/10.1016/j.mechmat.2023.104668.

## Dataset contents

This dataset contains the input parameters for the growth-based designs, as well as their respective homogenized stiffnesses. The dataset contains $1,000,000$ structure-property pairs.

The columns in `X_data.pth` correspond to the 14 spans defining the two star-shaped sets $\mathcal{S}$ and $\mathcal{S}^*$ (i.e., 7 each): $\{r_1,r_2,r_3,r_4,r_5,r_6,r_7,r^{*}_1,r^{*}_2,r^{*}_3,r^{*}_4,r^{*}_5,r^{*}_6,r^{*}_7\}$.

The columns in `y_data.pth` correspond to the 6 independent stiffness matrix components (in Mandel notation): $\xi = \{\hat{C}_{11}, \hat{C}_{12}, \hat{C}_{13}, \hat{C}_{22}, \hat{C}_{23}, \hat{C}_{33}\}$

### Design generation

To generate the growth-based cellular metamaterials designs, we used the following open-source code:
https://github.com/mfx-inria/auxeticgrowthprocess2d

The input parameter file (named `input_file.txt`) of any given design should be as follows:

```sh
name=./star_shape
radial_spans=r1,r2,r3,r4,r5,r6,r7
max_growth_length_radial_spans=R1,R2,R3,R4,R5,R6,R7
point_process=File
interpolation_type=PolarCubic
image_size=K
symmetry_type=NoSymmetry
plot_starshaped_ppm=false
plot_starshaped_pdf=true
plot_sites_pdf=false
save_porous_material_ppm=true
save_results_txt=false
plot_porous_material_sites_png=true
num_growth_plots=0
save_non_regularized=false
filename_points=./points_lattice.txt
```

Where the `r1,..,r7` correspond to the spans defining the star-shaped set $\mathcal{S}$ and `R1,...,R7` correspond to the spans defining the star-shaped set $\mathcal{S}^*$. Please refer to the value ranges as described in the publication.

Moreover, the `points_lattice.txt` file contains:
```sh
0.5,0.5
```
This defines the position of the nucleus in the domain (i.e., in the middle of the domain).

To generate a black-and-white image of the unit cell, run the following (after building the `growthProcess2d` executable from the aforementioned repository):
```sh
./growthprocess2d input_file.txt
```

### FFT-based homogenization

To efficiently homogenize our metamaterial designs we utilised the following open-source code:
https://github.com/sbrisard/janus

The unit cell images have to be converted into 2D arrays containing `0`'s (void phase) and `1`'s (solid phase) before the homogenization. # Inverse-designed Growth-based Metamaterials