from IPython.core.display import display, HTML
import logging


class NotebookHandler(logging.Handler):

    html_fmt = """\
<div class="output_stream" style="background-color: rgb(256, 245, 230);
                              padding: 0 0.42em;
                              margin: -0.42em;
                              font-size: 95%;
                              line-height: 18px">
<pre>{}</pre>
</div>"""

    def emit(self, record):
        try:
            msg = self.format(record)
            display(HTML(self.html_fmt.format(msg)))
        except (KeyboardInterrupt, SystemExit):
            raise
        except:
            self.handleError(record)

