from .sql import DatabaseHandler, SQLiteDatabaseHandler
from .notebook import NotebookHandler
import logging


__all__ = ['DatabaseHandler', 'SQLiteDatabaseHandler', 'NotebookHandler', 'setup']


def setup(modules, handler=None, level='INFO', fmt="%(levelname)s :: %(name)s :: %(message)s"):
    if handler is None:
        handler = logging.StreamHandler()

    if not isinstance(fmt, logging.Formatter):
        fmt = logging.Formatter(fmt)

    handler.setLevel('DEBUG')
    handler.setFormatter(fmt)

    if not isinstance(modules, (list, tuple)):
        modules = [modules]

    for i, m in enumerate(modules):
        if not isinstance(m, str):
            try:
                m = m.__module__+m.__name__
            except AttributeError:
                m = m.__name__

        l = logging.getLogger(m)
        l.setLevel(level)
        l.handlers = [handler]
