from ..datasets import griddata, landboundaries
import numpy as np


def overview(ax, boxes, lw=1, labels=None, labeldict=None, labelpos=(.5, .5), ldbdict=None, **kw):
    landboundaries.NL.plot(ax, scale=.001, **(ldbdict or dict()))
    ax.set_xlim(440, 650)
    ax.set_ylim(5700, 5930)
    ax.set_aspect('equal')
    ax.set_xlabel('easting (km)')
    ax.set_ylabel('northing (km)')

    colors = kw.pop('colors', [kw.pop('color', 'r')]*len(boxes))

    if labeldict is None:
        labeldict = dict()
    labeldict.setdefault('ha', 'center')
    labeldict.setdefault('va', 'center')

    if isinstance(labelpos, (int, float)):
        labelpos = (labelpos, labelpos)

    for i, b in enumerate(boxes):
        if isinstance(b, griddata.GridDataset):
            b = b.position

        xll, yll, w, h = b
        x = np.array([xll, xll + w, xll + w, xll, xll]) * .001
        y = np.array([yll, yll, yll + h, yll + h, yll]) * .001

        ax.plot(x, y, color=colors[i], lw=lw, **kw)

        if labels is not None:
            ax.text(.001 * (xll + labelpos[0] * w), .001 * (yll + labelpos[1] * h), labels[i], **labeldict)

