from io import StringIO
import requests
from requests.auth import HTTPBasicAuth
import pandas as pd
import numpy as np

_DATA = None


def load(username, pw, meta_url='https://repos.deltares.nl/repos/ODyn/trunk/RawData/Metadata/metadata.txt'):
    r = requests.get(meta_url, auth=HTTPBasicAuth(username, pw))
    data = pd.read_csv(StringIO(r.text))
    data.Start = pd.to_datetime(data.Start, format='%Y%m%d')
    data.End = pd.to_datetime(data.End, format='%Y%m%d')
    data.Method = data.Method.replace('xxxx', '')
    return data


def get_by_sid(sid, **kw):
    global _DATA
    if _DATA is None:
        _DATA = load(**kw)
    return _DATA[_DATA.Filename == sid].squeeze().to_dict()
