import logging
import zipfile
import re


__all__ = ['guess_ftype', 'is_ascii']


def guess_ftype(f, datatype='grid'):
    logging.getLogger(__name__).debug('guessing filetype of {!r}'.format(f))

    def _guess_ftype(f, datatype='grid'):
        if isinstance(f, str):
            import pdb; pdb.set_trace()
            with open(f, 'rb') as fh:
                firstline = fh.readline()
                secondline = fh.readline()
        elif isinstance(f, zipfile.ZipExtFile):
            try:
                firstline, secondline = f.peek(255).split('\n', 1)
            except ValueError:
                pass
        elif all(hasattr(f, name) for name in ['seek', 'readline']):
            firstline = f.readline()
            secondline = f.readline()
            f.seek(0)
        else:
            raise TypeError('cannot guess filetype of {}'.format(f.__class__))

        if datatype == 'grid':
            if firstline and is_ascii(firstline):
                return 'ASC'
            elif firstline[:3] == 'CDF':
                return 'NC'
        elif datatype == 'gridstack':
            if firstline[:3] == 'CDF':
                return 'NC'
        elif datatype == 'points':
            if secondline and is_ascii(secondline):
                if re.match('[0-9\.E\+]+,[0-9\.E\+]+', secondline):
                    return 'CSV'
                elif re.match('[0-9\.E\+]+\s+[0-9\.E\+]+', secondline):
                    return 'XYZ'

        raise ValueError('could not guess file type of {!r}'.format(f))

    out = _guess_ftype(f, datatype=datatype)
    logging.getLogger(__name__).info('guessed filetype {} for {!r}'.format(out, f))

    return out


def is_ascii(s):
    return all(ord(c) for c in s)