from .sources import *
from .reading import load_griddata, load_gridstackdata, load_pointdata
from .writing import save_griddata, save_gridstackdata, save_pointdata


def search_nc(xll, yll, w, h, catalogpath=None,
              t=None, sid=None, min_density=None, min_coverage=None, **kw):
    records = NCCatalog(catalogpath).list(
        xll=xll, yll=yll, w=w, h=h,
        t=t, sid=sid, min_density=min_density, min_coverage=min_coverage, **kw)
    return records.locations


def search(xll, yll, w=5000, h=5000,
           catalogpath=None, collapse='recent', t=None, sid=None,
           min_density=None, min_coverage=None, **kw):
    """
    search for a grid dataset at a specific location
    :param xll: x coordinate (km in UTM31) of the lower left corner
    :param yll: y coordinate (km in UTM31) of the lower left corner
    :param w: width of the dataset (km)
    :param h: height of the dataset (km)
    :param catalogpath: path of the catalog
    :param collapse: method to collapse timesteps (recent|first|second)
                     see: sandwaves.datasets.timeseries_selectors.collapse_timeseries()
    :param t: timestep
    :param sid: survey ID
    :param min_density: minimum points/m2
    :param min_coverage: minumum area coverage (ratio)
    :return: GridDataset instance
    """
    kw['ti'] = collapse
    return NCCatalog(catalogpath, datatype='gridobj').list(
        xll=xll, yll=yll, w=w, h=h, t=t, sid=sid,
        min_density=min_density, min_coverage=min_coverage, **kw).join()


def search_stack(xll, yll, w=5000, h=5000, catalogpath=None, min_density=None, min_coverage=None, **kw):
    """
    search for a stacked grid dataset at a specific location
    :param xll: x coordinate (km in UTM31) of the lower left corner
    :param yll: y coordinate (km in UTM31) of the lower left corner
    :param w: width of the dataset (km)
    :param h: height of the dataset (km)
    :param catalogpath: path of the catalog
    :param min_density: minimum points/m2
    :param min_coverage: minumum area coverage (ratio)
    :return: GridTimeStackDataset instance
    """
    return NCCatalog(catalogpath, datatype='gridstackobj').list(
        xll=xll, yll=yll, w=w, h=h,
        min_density=min_density, min_coverage=min_coverage, **kw).join()
