from __future__ import print_function, division
import numpy as np
from .. import utils
from ..transformations import Fourier
from . import extremes
from . import shape
from . import transects


def direction(x, y, data, lmin=100, lmax=1000):
    kmin = 1. / lmax
    kmax = 1. / lmin

    f_full = Fourier.transform(x, y, utils.prepare(data, avg=True, unmask=True, taper=True))
    f = f_full.filter(kmin=kmin, kmax=kmax)
    return _fit_direction(f)


def _fit_direction(f):
    Kx, Ky = np.meshgrid(f.kx, f.ky)

    angles = np.linspace(0, np.pi, 180)
    SSres = np.zeros(angles.shape)

    for i, a in enumerate(angles):
        slope = np.tan(a)
        err = f.amplitude*np.absolute(slope*Kx-Ky)/np.sqrt(slope**2+1)
        SSres[i] = np.sum(err**2)

    i_min = np.argmin(SSres)
    angle = angles[i_min]

    return angle*180/np.pi