## Steering and collecting valley-polarized electron jets in bilayer graphene

By Josep Ingla-Aynés, Antonio L. R. Manesco, Talieh S. Ghiasi, Serhii
Volosheniuk, Kenji Watanabe, Takashi Taniguchi, and Herre S. J. van der Zant

### Folders

#### `theoretical_calculations`

* Subfolders:
  + `data`: data obtained from the experiments and simulations
  + `modules`: python modules to perform the calculations
* Files
  + `collimation.py`: computes collimation "spectrum" for experimental parameters
  + `effective_width.py`: determines the effective width of the injector to match conductance data
  + `experimental_fermi_surface.py`: computes Fermi surface using experimental parameters
  + `figures.py`: examples of how to generate figures for data analysis
  

#### `experiments`

  * General naming measurement datafiles:

    MXX_BLGhBN14_I[I+ I-]_AppliedCurrent_V[V1+ V1-]_[Ampl1]x_V[V2+ V2-]_[Ampl2]x

    + XX is the measurement number
    + BLGhBN14 is the name of the sample
	+ I+(-): Number identifying the contact connected to the I+ (I-:ground) terminal. 
	+ V1(2)+(-): Number identifying the contact connected to the V+ (V-) terminal of the first (second) channel.
	+ Ampl1(2) amplification of the preamplifier connected to channel 1 (2). 
	Note that the measured voltages have been normalized by the apropriate
    amplification before saving, implying that there is no need to further correct it. 
	+ The numbers identifying the contacts can be correlated with the contacts using MapContactNumbers.png
	+ In all cases, the split gates surrounding the relevant contacts were connected

* Collimation experiments vs Vbg:
Required to generate Fig. 2c, Fig. S2, and Fig. S5.
Python script: CleanedPlotCollimationVsVbg.py
Measurement files (C1 and C2 stand for the measurement configurations described in the article: https://arxiv.org/abs/2310.15293):
C1: M07, M11, M12.
C2: M68 and M71.

* Temperature dependence in Fig. 4 and Fig. S4:
CleanedAnalysisTdepCollimation
M59, M60, M61, M65, M66

* Vtg dependence in Fig. S3:
Measurement file: M46
Analysis python script: AnalysisVtgDepVbg1p3V


### Installation

Install [miniconda](http://conda.pydata.org/miniconda.html) and then the Python environment that contains all dependencies with:
```
conda env create -f environment.yml
```
then activate it with
```
source activate electron_collimation_blg
```

Finally, run the command `jupyter lab` to run the notebooks.

The plots require LaTeX installed. In Debian/Ubuntu, run:

```
sudo apt-get install texlive-full
```
or comment the custom `matplotlib` `rcParams`.
