from modules import semiclassics
import xarray as xr
import matplotlib.pyplot as plt
from scipy import optimize, interpolate, signal, integrate, special

ds = xr.load_dataset('./data/experimental_fermi.nc')
# ds = ds.where(ds.experiment > 0.8, drop=True)
dataset = ds.sel(alpha=1.2, misalignment=0, experiment=0, valley = 1, method='nearest')

# +
import matplotlib.pyplot as plt

fig = plt.figure()
ax = fig.add_subplot(111, polar=True)
dataset.kF.plot(
    ax=ax
)
plt.show()
# -

import numpy as np
B = 0.1
kF = dataset.kF.data[:: int(np.sign(B))]
polar_angles = dataset.phis.data[:: int(np.sign(B))]
phic = 0
k = semiclassics.kx_ky(k_F=kF, phi=polar_angles, phic=phic)
occupation, n = semiclassics.quantization(
    k=k,
    phic=phic,
    U=dataset.U.data,
    valley=dataset.valley.data,
    mu=dataset.mu.data,
    Ec=dataset.Ec.data,
    Ecmax=dataset.Ecmax.data,
    W=dataset.attrs["Wc"],
    alpha=dataset.alpha.data,
)
print(n)

# For the lowest experimental value of gate voltage the number of modes match the experiment.

dataset = ds.sel(alpha=1, misalignment=0, experiment=5, valley = 1, method='nearest')

import numpy as np
B = 0.1
kF = dataset.kF.data[:: int(np.sign(B))]
polar_angles = dataset.phis.data[:: int(np.sign(B))]
phic = 0
k = semiclassics.kx_ky(k_F=kF, phi=polar_angles, phic=phic)
occupation, n = semiclassics.quantization(
    k=k,
    phic=0,
    U=dataset.U.data,
    valley=dataset.valley.data,
    mu=dataset.mu.data,
    Ec=dataset.Ec.data,
    Ecmax=dataset.Ecmax.data,
    W=dataset.attrs["Wc"],
    alpha=dataset.alpha.data,
)
print(n)

# It doesn't match for the largest gate voltage, so we will set it to a larger value to agree with conductance data.

import numpy as np
B = 0.1
kF = dataset.kF.data[:: int(np.sign(B))]
polar_angles = dataset.phis.data[:: int(np.sign(B))]
phic = 0
k = semiclassics.kx_ky(k_F=kF, phi=polar_angles, phic=phic)
occupation, n = semiclassics.quantization(
    k=k,
    phic=0,
    U=dataset.U.data,
    valley=dataset.valley.data,
    mu=dataset.mu.data,
    Ec=dataset.Ec.data,
    Ecmax=dataset.Ecmax.data,
    W=150e-9,
    alpha=dataset.alpha.data,
)
print(n)

# +
delta_n = ds.n_exp.sel(experiment=3, method="nearest") - ds.n_exp.sel(
    experiment=0, method="nearest"
)
delta_W = 100e-9


def compute_width(n):
    return (
        n - ds.n_exp.sel(experiment=0, method="nearest")
    ) * delta_W / delta_n + ds.attrs["Wc"]


# -

Ws = compute_width(ds.n_exp)

ds = ds.assign(
    {
        'W': ('experiment', Ws.data)
    }
)

ns = []
for experiment in ds.experiment:
    _ns = []
    for alpha in ds.alpha:
        dataset = ds.sel(alpha=alpha, experiment=experiment, valley=1, method='nearest')
        occupation, n = semiclassics.quantization(
            k=k,
            phic=0,
            U=dataset.U.data,
            valley=dataset.valley.data,
            mu=dataset.mu.data,
            Ec=dataset.Ec.data,
            Ecmax=dataset.Ecmax.data,
            W=dataset.W.data,
            alpha=dataset.alpha.data,
        )
        _ns.append(n)
    ns.append(_ns)

ds = ds.assign(
    {
        'n': (['experiment', 'alpha'], np.array(ns))
    }
)

ds.to_netcdf('./data/experimental_fermi.nc')
