# -*- coding: utf-8 -*-
"""
Created on Sun Jan  7 18:05:44 2024

@author: Pep
"""

import numpy as np
import matplotlib.pyplot as plt
from scipy.optimize import curve_fit
import scipy.constants as c
from scipy.signal import find_peaks, peak_prominences, savgol_filter

font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
######## Constants
el = 1.602E-19
hbar = 1.05457182E-34
L = 4E-6
B0 = 0.074
Vg0 = 0.0


def Bmax_fun(n):
    return 2*hbar*np.sqrt(np.pi*n)/(el*L)


def sinalpha_fun(B, n, B0):
    if B[1]>B[0]:
        B0 = -B0
    return el*(B-B0)*4E-6/(2*hbar*np.sqrt(np.pi*n))


def map_peaks(x, y, d=3):
    # width specified to extract peak widths
    peaks, props = find_peaks(y, distance = d, prominence=0.2,
                              rel_height=0.15, width=[1])
    xmax=x[peaks]
    return xmax, peaks, props['widths']


def default_color_cycle():
    # Back to default color cycle
    new_colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728',
                  '#9467bd', '#8c564b', '#e377c2', '#7f7f7f',
                  '#bcbd22', '#17becf']
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=new_colors)
    return


def plot_collimation(filename, I, Vbgrange = [0], DR=50, figure=True, Vbgset=[], trace=False, text=True):
    
    if type(filename)==str:
        filename = [filename]
    for i, f in enumerate(filename): 
        if i==0:
            data=np.loadtxt(f, skiprows = 28)
        else:
            data1=np.loadtxt(f, skiprows = 28)
            data = np.vstack((data, data1))
    B, Vbg, Vtg, Vdiff, *other = data.T
    Vbgs = np.sort(np.unique(Vbg))
    if len(Vbgrange)>1:
        filt_range = np.multiply(Vbgs < max(Vbgrange), Vbgs > min(Vbgrange))
    else: 
        filt_range = np.abs(Vbgs) > Vbgrange
    if len(Vbgset)>1:
        filt_range = np.array([np.round(Vb,2) in Vbgset for Vb in Vbgs])
    Vbgs = Vbgs[filt_range]
    print(Vbgs)
     
    Vbginc_arr=np.array([])
    Binc_arr=np.array([])
    Vdiffinc_arr=np.array([])
    Bmax = []
    offsets = []
    n_list = []
    areas = []
    if figure:
        plt.figure(figsize=[6.4, 6.5])
    for i, Vb in enumerate(Vbgs):
        filt1 = Vbg == Vb
        Binc = B[filt1][400:800]-B0
        Vdiffinc = Vdiff[filt1][400:800]
        if trace:
            Binc = B[filt1][:400]+B0
            Vdiffinc = Vdiff[filt1][:400]
        Binc_arr=np.append(Binc_arr,Binc)
        Vdiffinc_arr=np.append(Vdiffinc_arr,Vdiffinc)
        Vbginc_arr=np.append(Vbginc_arr,(Vbg[filt1])[400:800])
        offset = i*DR
        offsets.append(offset)
        
        plt.plot(Binc * 1e3, (Vdiffinc)/I+offset,linewidth=3,
                 label='$V_\mathrm{}={}$ V'.format('{bg}',round(Vb,2)))
        plt.plot([-0.25 * 1e3, 0.25 * 1e3], [offset, offset],'--',c='gray')
        plt.title('$V_\mathrm{}={}$ V'.format('{bg}',round(Vb,2)))
        if text:
            plt.text(0.1 * 1e3, (i+0.1)*DR,'$V_\mathrm{}={}$ V'.format('{bg}',round(Vb,2)))
        n = np.abs(0.001445*(Vb+Vg0)/el)
        n_list.append(n)
        Bmax.append(Bmax_fun(n))
        Bout = Binc-B0
        areas.append(np.trapz(Vdiffinc[np.abs(Bout)<Bmax_fun(n)]/I,
                              x=Bout[np.abs(Bout)<Bmax_fun(n)])/Bmax_fun(n))
        #print(max((Vdiffinc)*2E7))
        #popt, pcov = curve_fit(lorentz, Binc-B0, Vdiffinc*2E7)#,bounds=([-0.01, 0.01, 1E-2, -10],[0.01, 0.5, 1, 10])
    ### Appending offset and n values to calculate Bmax
    if len(offsets)>1:
        doffsets = offsets[-1] - offsets[-2]
        offsets.append(offsets[-1] + 2 * doffsets)
        offsets.insert(0, offsets[0] - doffsets)
        dn_list = n_list[-1] - n_list[-2]
        n_list.append(n_list[-1] + dn_list)
        n_list.insert(0, n_list[0] + dn_list)
        Bmax.append(Bmax_fun(n_list[-1]))
        Bmax.insert(0, Bmax_fun(n_list[0]))
    ### Bmax gray areas and fine tuning plot
    plt.fill_betweenx(offsets, np.array(Bmax) * 1e3, 0.25 * 1e3, facecolor = 'gray', alpha = 0.25)
    plt.fill_betweenx(offsets, -np.array(Bmax) * 1e3, -0.25 * 1e3, facecolor = 'gray', alpha = 0.25)
    #plt.legend(bbox_to_anchor=(1,1))#loc='upper left'
    plt.xlim([-0.23 * 1e3, 0.23 * 1e3])
    #plt.ylim([-(DR/2+5),DR*len(Vbgs)])
    plt.xlabel('$B$ (mT)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    #plt.savefig('CollimationRnlvsB_BmaxGrayLines.pdf')
    #plt.show()
    return Vbgs, areas

def PlotBmaxvsVbg(filename, Vbgrange=[0], I=1E-7, Vbgset=[], plotRnl=False):
    global Vbg_max_arr, Berr_arr
    for i, f in enumerate(filename):
        if i==0:
            data = np.loadtxt(f, skiprows = 28)
        else:
            data = np.vstack((data, np.loadtxt(f, skiprows = 28)))
    B, Vbg, Vtg, Vdiff, *other = data.T
    Vbgs = np.sort(np.unique(Vbg))
    if len(Vbgrange)>1:
        filt_range = np.multiply(Vbgs<max(Vbgrange), Vbgs>min(Vbgrange))
    else: 
        filt_range = np.abs(Vbgs)>Vbgrange
    if len(Vbgset)>1:
        filt_range = np.array([np.round(Vb,2) in Vbgset for Vb in Vbgs])
    Vbgs = Vbgs[filt_range]
    Bmax_arr = []
    dB_max_arr = []
    Vbg_max_arr = []
    Prompeaks_arr = []
    Berr_arr = []
    dBerr = []
    Berr_arr2 = []
    for i, Vb in enumerate(Vbgs):
        n = np.abs(0.001445*(Vb+Vg0)/el)
        filt1 = Vbg == Vb
        Binc = B[filt1][400:800]
        sinalpha = sinalpha_fun(Binc, n, B0)
        filt_sinalpha = np.abs(sinalpha) < 0.99
        Binc = Binc[filt_sinalpha]
        Vdiffinc = (Vdiff[filt1][400:800])[filt_sinalpha]
        if plotRnl:
            plt.plot(Binc-B0, Vdiffinc/I)
        #print('BincMin{}Max{}'.format(min(Binc),max(Binc)))
        #### Find peak positions
        Bmax, ind_max, Peakwidths = map_peaks(Binc-B0, Vdiffinc/max(Vdiffinc), d=3)
        dBmeas = np.mean(np.diff(Binc))#(Binc[ind_max]-Binc[ind_max-1])
        Berr = np.sqrt(np.sum((Peakwidths * dBmeas)**2))
        Berr_arr.append(Berr)
        #print('Bmax0={}'.format(Bmax))
        #Berr_arr2 = np.append(Berr_arr2 ,Berr)
        if len(Bmax) == 2:
            dB_max_arr.append(Bmax[1] - Bmax[0])
            dBerr.append(np.sqrt(np.sum((Peakwidths * dBmeas)**2)))
            
        for j, a, p in zip(ind_max, Bmax, Peakwidths):
            Berr_arr2.append(p * dBmeas)
            
            Bmax_arr.append(a)
            Vbg_max_arr.append(Vb)
            Prompeaks_arr.append(peak_prominences(Vdiffinc/I,peaks=[j]))
            
    Vbg_max_arr = np.array(Vbg_max_arr)
    Vbgmaxs = np.unique(Vbg_max_arr)
    Bmax_arr = np.array(Bmax_arr, dtype='object')
    Berr_arr = np.array(Berr_arr, dtype='object')
    plt.figure(figsize=[4,3])
    Co = ['#0000e8ff', '#b20000ff'] # The first is dark blue and the second dark red 
    Bmaxmax = [max(Bmax_arr[Vbg_max_arr==V]) for V in Vbgmaxs]
    Bmaxmin = [min(Bmax_arr[Vbg_max_arr==V]) for V in Vbgmaxs]
    Berrset = [np.array(Berr_arr2)[Vbg_max_arr==V][0] for V in Vbgmaxs]
    Berrset2 = [np.array(Berr_arr2)[Vbg_max_arr==V][1] if type(V)!=np.float64 else np.array(Berr_arr2)[Vbg_max_arr==V][0] for V in Vbgmaxs ]
    #print('Berr={}'.format(Berrset))
    #print('Bmax={}'.format(Bmaxmax))
    #print('Bmin={}'.format(Bmaxmin))
    plt.errorbar(Vbgmaxs[2:], (np.array(Bmaxmin[2:])) * 1E3,
                 yerr=np.array(Berrset[2:]) * 1E3, fmt='o-', capsize=3, color=Co[0])# blue
    
    plt.errorbar(Vbgmaxs[2:], (np.array(Bmaxmax[2:])) * 1E3,
                 yerr=np.array(Berrset2[2:]) * 1E3, fmt='o-', capsize=3, color=Co[1])#b20000ff is red
    plt.ylabel('$B_\mathrm{max}$ (mT)', fontsize=20)
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    #plt.yticks([-20,0,20])
    #plt.ylim([-22, 50])
    plt.savefig('BmaxvsVbg.pdf')
    plt.show()
    plt.figure(figsize=[4,2.5])
    Prom = np.array([p[0] for p in Prompeaks_arr])
    #Prom2 = [p[0] for p in Prompeaks2_arr]
    
    Promax = [max(Prom[Vbg_max_arr==V]) for V in Vbgmaxs]
    Promin = [min(Prom[Vbg_max_arr==V]) for V in Vbgmaxs]
    plt.plot(Vbgmaxs, Promin, 'o-', c=Co[0])
    plt.plot(Vbgmaxs, Promax, 'o-', c=Co[1])
    #plt.plot(Vbg_max2, Prom2)
    plt.ylabel('$\Delta R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    #plt.yticks([-20,0,20])
    plt.savefig('SignalAmplitudevsVbg.pdf')
    plt.show()
    return Vbgmaxs, Promin, Promax, Bmaxmin, Bmaxmax, Berr_arr


def PlotC1C2(filename, Vbgrange=[0], I=1E-7, dR=50, Vbgset=[],
                 rec=False, trace=False):
    '''
    Plots each curve to compare C1 with C2 data.
    Parameters
    ----------
    filename : TYPE
        DESCRIPTION.
    Vbgrange : TYPE, optional
        DESCRIPTION. The default is [0].
    I : TYPE, optional
        DESCRIPTION. Applied current, the default is 1E-7.
    Vbgset : TYPE, optional
        DESCRIPTION. The default is [], allows to specify specific Vbg values.
    rec : TYPE, optional
        DESCRIPTION. Changes sign of B, useful to compare C1 with C2 measurements which are reciprocal equivalents.
    trace : TYPE, optional
        DESCRIPTION. Allows to plot trace and retrace.

    Returns
    -------
    fit parameters

    '''
    for i, f in enumerate(filename):
        if i==0:
            data = np.loadtxt(f, skiprows = 28)
        else:
            data = np.vstack((data, np.loadtxt(f, skiprows = 28)))
    B, Vbg, Vtg, Vdiff, *other = data.T
    Vbgs = np.sort(np.unique(Vbg))
    if len(Vbgrange)>1:
        filt_range = np.multiply(Vbgs<max(Vbgrange), Vbgs>min(Vbgrange))
    else: 
        filt_range = np.abs(Vbgs)>Vbgrange
    if len(Vbgset)>1:
        filt_range = np.array([np.round(Vb,2) in Vbgset for Vb in Vbgs])
    Vbgs = Vbgs[filt_range]
    for i, Vb in enumerate(Vbgs):
        filt1 = Vbg == Vb
        Binc = B[filt1][400:800]-B0
        Vdiffinc = Vdiff[filt1][400:800]
        if trace:
            Binc = B[filt1][:400]+B0
            Vdiffinc = Vdiff[filt1][:400]
        if rec:
            Binc = -Binc
        plt.plot(Binc, Vdiffinc/I+i*dR, 'o-')
        plt.xlim([-0.1, 0.1])
    return
#%%
Vbgrange = [0]
filename1 = 'M07_BLGhBN14_I28to03_100nA_V32to02_100x.dat'
filename2 = 'M11_BLGhBN14_I28to03_100nA_V32to02_100x.dat'
filename3 = 'M12_BLGhBN14_I28to03_100nA_V32to02_100x.dat'
filename = [filename1, filename2, filename3]
#%%
Vbgmaxs, Promin, Promax, Bmaxmin, Bmaxmax, Berrarr = PlotBmaxvsVbg(filename,
                                                          Vbgrange=[-5,4])
plt.show()
Vbgs, areas = plot_collimation(filename, I=1E-7, Vbgrange=[0], DR=50,
                 figure=True)
plt.ylim([-30, 780])
plt.savefig('VbgDepCollimationFigS2.pdf')
plt.show()
#%%
Vlist = [-3, 0.80, 1.3, 1.74, 1.96, 2.4, 3.0]
        #1 ,  1.16,  1.3,  1.52,  1.74, 1.96,  2.15,  2.4,  2.64,  3.0 ]
Vbgs, areas = plot_collimation(filename, I=1E-7, Vbgset=Vlist, DR=50,
                 figure=True)
plt.ylim([-10, 360])
plt.savefig('VbgDepCollimationFig2c.pdf')
#%% Delta B 
def sqrt_fun(x, a):
    return a * np.sqrt(x)
Vbg1 = np.array([0.79789425, 0.9999237 , 1.16014343, 1.29991608, 1.51995117,
       1.73998627, 1.96002136, 2.15014878, 2.40009155, 2.63996338,
       3.0000763 ])
DB1 = np.array([0.01803, 0.02312, 0.02174, 0.02451, 0.03284, 0.03469, 0.03701,
       0.03978, 0.04117, 0.04163, 0.04811])
dBpos = np.array([5e-3, 5e-3, 5e-3, 5e-3, 5e-3, 5e-3, 0.015, 0.02, 0.0175, 2.0e-2, 2.0e-2])/2
dBneg = np.array([2e-3, 5e-3, 1e-2, 5e-3, 1e-2, 8e-3, 1e-2, 5e-3, 1.5e-2, 1.0e-2, 1.0e-2])/2 
dDBpos = np.sqrt(dBpos**2 + dBneg**2)
popt, perr = curve_fit(lambda Vbg1, a: sqrt_fun(Vbg1, a),
                                  Vbg1, DB1, p0=21E-3)
Vbgmap = np.linspace(min(Vbg1), max(Vbg1), 100)
Cbg =  0.00144
n = Cbg * Vbgmap / c.e
plt.figure(figsize=[4,2.5])
plt.errorbar(Vbg1, DB1 * 1e3, dDBpos * 1e3, fmt='o', label='C1', capsize=2, color='k')
p = np.polyfit(Vbg1, DB1, 1)
pol = np.poly1d(p)
Vbg2 = np.array([0.8, 1.3, 1.9, 3])
DB2 = np.array([0.015,0.0193,0.033, 0.026])
dDB2 = np.array([0.003, 0.002, 0.0006, 0.01])
plt.errorbar(Vbg2[:-1], DB2[:-1] * 1e3, dDB2[:-1] * 1e3, fmt= 's', label='C2',
             capsize=2, color='r')
####### Simulations results
Vbg = [0.999924, 1.160143, 1.299916, 1.519951, 1.739986, 1.960021, 2.150149,
       2.400092, 2.639963, 3.000076]

### Peak separation from simulations alpha = 1.2
DBmax1p2 = [10.84337349, 13.25301205, 18.07228916, 18.07228916, 22.89156627,
            25.30120482, 30.12048193, 30.12048193, 34.93975904, 42.1686747]
### Peak separation from simulations alpha = 1.0
DBmax1 = [15.06024,15.6626506, 22.89156627, 20.48192771, 27.71084337,27.71084337,
          32.53012048, 37.34939759,  39.75903614, 44.57831325, 49.39759036]
### Peak separation from simulations alpha = 0.8
DBmax0p8 = [25.30120482,27.71084337,30.12048193,34.93975904, 39.75903614,
            42.1686747 , 42.1686747 , 49.39759036,54.21686747, 61.44578313]
plt.fill_between(Vbg, DBmax0p8, DBmax1p2, alpha=0.4, color='gray')
Vbg.insert(0, 0.8)
plt.plot(Vbg, DBmax1, 'k', label='$\\alpha=1$')
###########
p = np.polyfit(Vbg2[:-1], DB2[:-1], 1)
pol = np.poly1d(p)
# plt.plot(Vbg2, pol(Vbg2)*1E3, c='C1')
plt.tick_params(direction='in', top=True, right=True,
                labelright=False, labelleft=True)
plt.ylabel('$\\Delta B_\mathrm{max}$ (mT)', fontsize=20)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.yticks([10,30,50])
plt.legend()
plt.savefig('PeakSeparationC1andC2VsVbg.pdf')
plt.show()
#%% C1 and C2
filename1 = 'M68_BLGhBN14_I06to02_100nA_V17to03_100x_V06to02_1x.dat'
filename3 = 'M71_BLGhBN14_I06to02_100nA_V17to03_100x_V06to02_1x.dat'

filenameb = [filename1, filename3]
Vbgrange_list = [[3, 4], [1.8, 2], [1.2, 1.4], [0.79, 0.95]]
Vbg_list = [3, 1.9, 1.3, 0.8]
for Vbgrange, Vbge in zip(Vbgrange_list, Vbg_list):
    PlotC1C2(filename, Vbgrange=Vbgrange, I=1E-7, trace=True)
    PlotC1C2(filenameb, Vbgrange=Vbgrange, I=1E-7, rec=True, trace=False)
    plt.legend(['C1($B$)', 'C2($-B$)'])
    #plt.plot([-0.028, -0.028], [20, 50])
    #plt.plot([-0.002, -0.002], [20, 50])
    plt.title('$V_\mathrm{}={}$ V'.format('{bg}', np.round(Vbge, 2)), fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
    plt.savefig('CollimationC1andC2_{}V.pdf'.format(np.round(Vbge, 2)))
    plt.show()