# -*- coding: utf-8 -*-
"""
Created on Thu Mar 28 12:59:27 2024

@author: jingla
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
import scipy.constants as c
from scipy.signal import find_peaks, peak_prominences
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
######## Constants
el = c.e
hbar = c.hbar
L = 4E-6
B0 = 0.074
Vg0 = 0.0

def Bmax_fun(n):
    return 2*hbar*np.sqrt(np.pi*n)/(el*L)

def plot_collimation_tg(filename, I, Vbgrange=[0], DR=50, prom=7,Vtg0=[]):
    '''
    Analysis and plot of the Vtg dependent collimation data

    Parameters
    ----------
    filename : TYPE
        DESCRIPTION.
    I : TYPE: float
        DESCRIPTION. Applied current, it is 1E-7 Amps
    Vbgrange : TYPE, optional
        DESCRIPTION. The default is [0].
    DR : TYPE, optional
        DESCRIPTION. The default is 50.
    prom : TYPE, optional
        DESCRIPTION. The default is 7.
    Vtg0 : TYPE, optional
        DESCRIPTION. The default is [].

    Returns
    -------
    None.

    '''
    if type(filename)==str:
        filename = [filename]
    for i, f in enumerate(filename): 
        if i==0:
            data=np.loadtxt(f, skiprows = 28)
        else:
            data1=np.loadtxt(f, skiprows = 28)
            data = np.vstack((data, data1))
    
    B, Vbg, Vtg, Vdiff, *other = data.T
    Vbgs = np.unique(Vtg)
    print(Vbgs)
    if len(Vbgrange)>1:
        filt_range = np.multiply(Vbgs<max(Vbgrange),Vbgs>min(Vbgrange))
    else: 
        filt_range = np.abs(Vbgs)>Vbgrange
    Vbgs = Vbgs[filt_range]
    Vbginc_arr=np.array([])
    Binc_arr=np.array([])
    Vdiffinc_arr=np.array([])
    Bmax = []
    Bpeaks = []
    dBpeaks = []
    Prompeaks = []
    Vgpeaks = []
    offsets = []
    n_list = []
    Rmax = []
    colormap = plt.cm.get_cmap('jet')
    plt.rcParams['axes.prop_cycle'] = plt.cycler(color=[colormap(k) for k in np.linspace(0, 1, len(Vbgs))])
    for i, Vb in enumerate(Vbgs):
        filt1 = np.round(Vtg,3) == np.round(Vb,3)
        Binc = B[filt1][400:800]
        Vdiffinc = Vdiff[filt1][400:800]
        Binc_arr=np.append(Binc_arr,Binc)
        Vdiffinc_arr=np.append(Vdiffinc_arr,Vdiffinc)
        Vbginc_arr=np.append(Vbginc_arr,(Vbg[filt1])[400:800])
        offset = i*DR
        offsets.append(offset)
        norm = mpl.colors.Normalize(vmin=Vbgs.min(), vmax=Vbgs.max())
        cmap = mpl.cm.ScalarMappable(norm=norm, cmap=mpl.cm.jet)
        cmap.set_array([])
        if i%2 == 0:
            plt.plot((Binc-B0)*1e3, (Vdiffinc)/I+offset,linewidth=3, c=cmap.to_rgba(Vb),
                     label='$V_\mathrm{}={}$ V'.format('{tg}', round(Vb,3)))
        n = np.abs(0.001445*(Vb+Vg0)/el)
        n_list.append(n)
        Bmax.append(Bmax_fun(n))
        Rmax.append(max((Vdiffinc)/I))
        inpeaks = find_peaks((Vdiffinc)/I, prominence=prom)
        inpeaks = inpeaks[0]
        if len(inpeaks)==2:
            dBpeaks.append(Binc[inpeaks[0]]-Binc[inpeaks[1]])
        
        for i in inpeaks:
            Vgpeaks.append(Vb)
            Bpeaks.append(Binc[i]-B0)
            Prompeaks.append(peak_prominences((Vdiffinc)/I,peaks=[i]))
    ### Appending offset and n values to calculate Bmax
    doffsets = offsets[-1] - offsets[-2]
    offsets.append(offsets[-1] + doffsets)
    offsets.insert(0, offsets[0] - doffsets)
    dn_list = n_list[-1] - n_list[-2]
    n_list.append(n_list[-1] + dn_list)
    n_list.insert(0, n_list[0] + dn_list)
    Bmax.append(Bmax_fun(n_list[-1]))
    Bmax.insert(0, Bmax_fun(n_list[0]))
    ### Bmax gray areas and fine tuning plot
    plt.fill_betweenx(offsets, Bmax, 0.25, facecolor = 'gray', alpha = 0.25)
    plt.fill_betweenx(offsets, -np.array(Bmax), -0.25, facecolor = 'gray', alpha = 0.25)
    plt.xlim([-75, 75])
    plt.xlabel('$B$ (mT)', fontsize=20)
    plt.ylabel('$R_\mathrm{nl}$ ($\Omega$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    plt.colorbar(cmap)
    plt.savefig('CollimationvsVtg.pdf')
    plt.show()
    plt.plot(Vbgs, Rmax, '-o')
    if type(Vtg0)==float:
        plt.vlines(Vtg0,np.max(Rmax),np.min(Rmax))
    plt.tick_params(direction='in', top=True, right=True)
    plt.xlabel('$V_\mathrm{tg}$ (V)', fontsize=20)
    plt.ylabel('$R_\mathrm{max}$ ($\\Omega$)', fontsize=20)
    plt.show()
    plt.figure(figsize=[2, 1.5])
    plt.plot(Vbgs[-len(dBpeaks):], np.abs(np.array(dBpeaks))*1E3,'o')
    plt.tick_params(direction='in', top=True, right=True)
    plt.ylabel('$\Delta B_\mathrm{peak}$ (mT)', fontsize=20)
    plt.xlabel('$V_\mathrm{tg}$ (V)', fontsize=20)
    plt.xlim([-2.75, -2.6])
    plt.savefig('BpeakvsVtg.pdf')
    plt.show()
    Prom = [p[0] for p in Prompeaks]
    plt.plot(Vgpeaks, Prom, 'o')
    plt.tick_params(direction='in', top=True, right=True)
    plt.ylabel('Peak prominence ($\\Omega$)', fontsize=20)
    plt.xlabel('$V_\mathrm{tg}$ (V)', fontsize=20)
    plt.xlim([-2.95, -2.6])
    plt.savefig('PeakPromvsVtg.pdf')
    return

#%% Vtg dep
filename=['M46_BLGhBN14_I32to02_100nA_V28to03_100x_V32to02_1x.dat']
plot_collimation_tg(filename, I=1E-7,DR=0,prom=10,Vtg0=-2.716)
