# -*- coding: utf-8 -*-
"""
Created on Thu Mar 28 13:16:03 2024

@author: jingla
"""
import numpy as np
import matplotlib.pyplot as plt
import scipy.constants as c
import matplotlib.cm as cm
from matplotlib.ticker import MultipleLocator
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)
######## Constants
el = 1.602E-19
hbar = 1.05457182E-34
L = 4E-6
B0 = 0.074
Vg0 = 0.0

def My_color_plot(x,y,z, xran=[], yran=[], zlim=[], n_ticks=5,tick_vals =[]):
    '''
    Creates color plots using a filled contour function
    To be as versatile as possible, the function does not have a plt.show()
    as this allows the axes labels to be defined apart.
    '''
    font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
    plt.rc('font', **font)
    if xran != [] and yran != []:
        xmin, xmax = min(xran), max(xran)
        ymin, ymax = min(yran), max(yran)
        filt_x = np.multiply(x<xmax,x>xmin)
        filt_y = np.multiply(y<ymax,y>ymin)
        filt = np.multiply(filt_x, filt_y)
        x = x[filt]
        y = y[filt]
        z = z[filt]
    
    x_uni = np.sort(np.unique(x))
    if x[0]>x[-1]:
        x_uni = x_uni[::-1]
    y_uni = np.sort(np.unique(y))
    if y[0]>y[-1]:
        y_uni = y_uni[::-1]
    x_grid, y_grid = np.meshgrid(x_uni, y_uni)
    z_grid = np.reshape(z, np.shape(x_grid)[::-1]).T
    if zlim == []:
        plt.contourf(x_grid, y_grid, z_grid,levels=200,vmin=0, cmap=cm.bwr)#inferno
    else:
        plt.contourf(x_grid, y_grid, z_grid,levels=200,vmin=min(zlim), vmax=max(zlim))
    plt.tick_params(direction='in', top=True, right=True)
    if tick_vals == []:
        zmax = np.floor(np.max(z_grid))
        zmin = np.floor(np.min(z_grid))
        ticks = np.linspace(zmin, zmax, n_ticks)
        t = [round(ti) for ti in ticks]
    else:
        t = tick_vals
    plt.colorbar(ticks=t)


def RmaxRminvsVbgPlot(filename, Vbglim=[]):
    '''
    Obtains the conductance of the QPC by subtracting the maximal from the minimal resistance
    at each Vbg from a R vs Vbg vs Vtg sweep.

    Parameters
    ----------
    filename : string
        DESCRIPTION. It is the filename where one can find the data
    Vbglim : TYPE, optional, list
        DESCRIPTION. The default is [], allows to specify the Vbg range to analyze

    Returns
    -------
    Vbgs : numpy array 
        DESCRIPTION. contains the different Vbg values without repetitions
    DRtg : numpy array
        DESCRIPTION. contains the increment in resistance at each Vbg by sweeping Vtg
    Vtgmax : numpy array
        DESCRIPTION. contains the Vtg where, for each Vbg, the resistance is maximal

    '''
    global Rmax, Rmin, DRtg, Vbgs, Vtgmax
    data=np.loadtxt(filename, skiprows = 31)
    Vbg, Vtg, Vdiff, *other = data.T
    R0 = 25812/2 #Ohms
    Vbgs = np.sort(np.unique(Vbg))
    if Vbglim != []:
        filt_Vbgs = np.multiply(Vbgs>min(Vbglim),Vbgs<max(Vbglim))
        Vbgs = Vbgs[filt_Vbgs]
    Vtgmax = []
    Rmax = []
    Rmin = []
    for Vb in Vbgs:
        filt = Vbg == Vb
        Vtgfilt = Vtg[filt]
        Vdifffilt = Vdiff[filt]
        imax = np.argmax(Vdifffilt)
        imin = np.argmin(Vdifffilt)
        Vtgmax.append(Vtgfilt[imax])
        Rmax.append(Vdifffilt[imax]*1E7)
        Rmin.append(Vdifffilt[imin]*1E7)
    plt.plot(Vbgs, R0/np.array(Rmax), 'o')
    plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
    plt.ylabel('$\Sigma$ ($2e^2/h$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    #plt.ylim([1,10])
    plt.grid()
    print(min(R0/np.array(Rmax)))
    np.savetxt(filename[:19]+'.dat', np.vstack((Vbgs, np.array(Vtgmax))).T)
    plt.savefig(filename[:19]+'.jpg')
    plt.show()
    DRtg = np.array(Rmax)-np.array(Rmin)
    plt.plot(Vbgs, DRtg)
    plt.ylabel('Rmax-Rmin')
    plt.xlabel('Vbg (V)')
    print('Vbgcnp={}V'.format(Vbgs[np.argmax(Rmin)]))
    print('Vtgcnp={}V'.format(Vtgmax[np.argmax(Rmin)]))
    print(min(np.array(Rmax[:-20])-np.array(Rmin[:-20])))
    print(filename[:19])
    
    return Vbgs, DRtg, Vtgmax
#%% M01 Colorplot QPC1 Fig S1
filename = 'M01_BLGhBN14_I03to28_100nA_V03to28_1x_V18to28_1x_Gatetrace.dat'
VbgsM1, DRtgM1, VtgmaxM1 = RmaxRminvsVbgPlot(filename, Vbglim=[-4,3])
sigma0 = c.e**2/c.h
GM1 = 1/(sigma0*DRtgM1*4)
plt.show()
data=np.loadtxt(filename, skiprows=30)
Vbg, Vtg, V2px, V2py, V3px, V3py, *other =data.T
plt.figure(figsize=[4,2.5])
My_color_plot(Vbg, Vtg, V3px * 1E7 *1E-3, tick_vals =[1,3,5,7])
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$V_\mathrm{tg}$ (V)', fontsize=20)
plt.savefig('ColormapM01.pdf')
plt.show()
#%% M02 Colorplot QPC2 Fig. S1
filename = 'M02_BLGhBN14_I03to32_100nA_V03to32_1x_V02to32_1x.dat'
VbgsM2, DRtgM2, VtgmaxM2 = RmaxRminvsVbgPlot(filename, Vbglim=[-4,3])
plt.show()
sigma0 = c.e**2/c.h
GM2 = 1/(sigma0*DRtgM2*4)
plt.plot(VbgsM2, GM2, 'o-')
plt.xlim([0,3])
plt.ylim([4,10])
plt.tick_params(direction='in',top=True, right=True)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$G$ (4$e^2/h$)', fontsize=20)
plt.title('M02', fontsize=20)
plt.grid()
plt.show()
# Colorplot M02
data=np.loadtxt(filename, skiprows=30)
Vbg, Vtg, V2px, V2py, V3px, V3py, *other =data.T
plt.figure(figsize=[4,2.5])
My_color_plot(Vbg, Vtg, V3px * 1E7 *1E-3, tick_vals =[0.5, 1, 1.5])
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$V_\mathrm{tg}$ (V)', fontsize=20)
plt.savefig('ColormapM02.pdf')
#%% Plot G emmitter vs G collector, Fig. S1: M1 M2 
fig, ax1 = plt.subplots(figsize=[4,2.5+0.5])
ax2 = ax1.twinx()

ax1.plot(VbgsM2, GM2, 'k-', label='Collector')
ax2.plot(VbgsM1, GM1, 'r-', label='Emitter')
ax1.minorticks_on()
ax2.set_ylim([0,10])
ax1.set_ylim([0,20])
plt.xlim([-4,3])

ax1.set_xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
ax2.set_ylabel('$G_\mathrm{e}$ (4$e^2/h$)', fontsize=20, color='r')
ax1.set_ylabel('$G_\mathrm{c}$ (4$e^2/h$)', fontsize=20)
ax1.tick_params(which='both',direction='in',top=True)

ax1.yaxis.set_minor_locator(MultipleLocator(2))
ax1.yaxis.set_major_locator(MultipleLocator(4))
ax2.yaxis.set_minor_locator(MultipleLocator(1))
ax2.yaxis.set_major_locator(MultipleLocator(2))

ax2.tick_params(which='both',direction='in')
#plt.title('M01', fontsize=20)
ax1.grid(which='both', axis='y')
plt.savefig('GEmitterAndCollectorM1M2.pdf')
#%% Color plot M19 Fig. 2a

filename='M19_BLGhBN14_I03to28_100nA_V03to28_1x_V18to28_1x.dat'
data=np.loadtxt(filename, skiprows=30)
Vbg, Vtg, V2px, V2py, V3px, V3py, *other =data.T
plt.figure(figsize=[5,2.5-0.5])
My_color_plot(Vbg, Vtg, V3px * 1E7 *1E-3, tick_vals =[1,3,5,7],
              xran=[0.0, 3.5], yran=[-5, -1.5])
plt.yticks([-2, -3, -4, -5])
plt.xticks([0, 1, 2, 3])
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('$V_\mathrm{tg}$ (V)', fontsize=20)
plt.savefig('ColormapM19.pdf')
plt.tick_params(direction='out')
plt.savefig('ColormapM19.png')
plt.show()
Vbgs, DRtg, Vtgmax = RmaxRminvsVbgPlot(filename, Vbglim=[-4,3])
sigma0 = c.e**2/c.h
G = 1/(sigma0*DRtg*4)
#%% Plot M2 M19. Fig. 2b
fig, ax1 = plt.subplots(figsize=[4,2.5+0.5])
ax2 = ax1.twinx()

ax1.plot(VbgsM2, GM2, 'k-', label='Collector')
ax2.plot(Vbgs, G, 'r-', label='Emitter')
ax1.minorticks_on()

ax1.set_xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
ax2.set_ylabel('$G_\mathrm{e}$ (4$e^2/h$)', fontsize=20, color='r')
ax1.set_ylabel('$G_\mathrm{c}$ (4$e^2/h$)', fontsize=20)
ax1.tick_params(which='both',direction='in',top=True)
plt.yticks([0,2,4,6,8,10])
plt.xlim([0.5, 3])
ax1.set_ylim([0, 14])
ax2.set_ylim([0, 7])
ax1.yaxis.set_minor_locator(MultipleLocator(2))
ax1.yaxis.set_major_locator(MultipleLocator(4))
ax2.yaxis.set_minor_locator(MultipleLocator(1))
ax2.yaxis.set_major_locator(MultipleLocator(2))

ax2.tick_params(which='both',direction='in')
#plt.title('M01', fontsize=20)
ax1.grid(which='both', axis='y')
plt.savefig('GEmitterAndCollector.pdf')