#files for gate voltages Vg = 1 to 5
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
import scipy.stats
from scipy.interpolate import interp1d
from mpl_toolkits.axes_grid1 import make_axes_locatable, axes_size

fig, ax = plt.subplots(nrows=1,ncols=1)

c7coeff=np.loadtxt('./Fliq-data/ed7gamma/c_coeff.dat',dtype='float')
b7=c7coeff[:,0]
a7=c7coeff[:,5]
s7=c7coeff[:,6]
cv7=c7coeff[:,4]

c3coeff=np.loadtxt('./Fliq-data/ed3gamma/c_coeff.dat',dtype='float')
b3=c3coeff[:,0]
a3=c3coeff[:,5]
s3=c3coeff[:,6]
cv3=c3coeff[:,4]

bnew=np.linspace(0,5,num=501,endpoint='True')

a3_cubic = interp1d(b3, a3, kind='cubic')
s3_cubic = interp1d(b3, s3, kind='cubic')
a7_cubic = interp1d(b7, a7, kind='cubic')
s7_cubic = interp1d(b7, s7, kind='cubic')

cv7_cubic = interp1d(b7, cv7, kind='cubic')
cv3_cubic = interp1d(b3, cv3, kind='cubic')

ax.plot(bnew,1.0*cv7_cubic(bnew)/cv7_cubic(0.0),linestyle='-',color='blue',label=r'$c_V(B)/c_V(0)#\;,v_g=1,\dots,5$')
ax.plot(bnew,1.0*cv3_cubic(bnew)/cv3_cubic(0.0),linestyle='-',color='blue')

ax.plot(bnew,a7_cubic(bnew)/a7_cubic(0.0),linestyle='-',color='black',label=r'$s_0(B)/s_0(0)#\;,v_g=1,\dots,5$')
ax.plot(bnew,a3_cubic(bnew)/a3_cubic(0.0),linestyle='-',color='black')#,label=r'$s_0\; (v_g=-3)$')

ax.plot(bnew,s7_cubic(bnew)/s7_cubic(0.0),color="orange",linestyle='--',label=r'$s_1(B)/s_1(0))#\;,v_g=1,\dots,5$')
ax.plot(bnew,s3_cubic(bnew)/s3_cubic(0.0),color="orange",linestyle='--')#,label=r'$s_1\; (v_g=-3)$')

ax.axes.set_aspect(aspect=0.8)
y1=a7_cubic(bnew)/a7_cubic(0.0)
y2=a3_cubic(bnew)/a3_cubic(0.0)
y3=s7_cubic(bnew)/s7_cubic(0.0)
y4=s3_cubic(bnew)/s3_cubic(0.0)
y5=cv7_cubic(bnew)/cv7_cubic(0.0)
y6=cv3_cubic(bnew)/cv3_cubic(0.0)

ax.fill_between(bnew,y1,y2,color='grey')
ax.fill_between(bnew,y3,y4,color='orange')
ax.fill_between(bnew,y5,y6,color='blue')

ax.set_xlabel(r'$g\mu_{\rm B}B/k_{\rm B}T_{K}$',fontsize='small')
ax.set_ylabel(r'$s_0(B)/s_0(0), s_1(B)/s_1(0), c_V(B)/c_V(0)$',fontsize='small')
ax.axhline(y=0, color="grey", linestyle="--")
ax.annotate(r'${\bf E}$',xy=(-0.1, 1.1), xycoords=ax.transAxes)
ax.set_xlim(xmin=0,xmax=2.0)
ax.set_ylim(ymin=-0.4,ymax=1.1)
legend = ax.legend(loc='lower left', shadow=False,frameon=False, fontsize='medium')

ax.annotate(r"$B_{\rm th}=B_c$",xy=(0.754,-0.01),xytext=(0.754,-0.3),color='red',ha="center",fontsize=14,
                 arrowprops=dict(arrowstyle="->",color='red',facecolor='red',lw='1'))
ax.annotate(r"$B_0(v_g=1)$",xy=(1.465,0.0),xytext=(1.465,-0.35),color='red',ha="center",fontsize=14,arrowprops=dict(arrowstyle="->",color='red',facecolor='red',lw='1'))
ax.annotate(r"$B_0(v_g=5)$",xy=(1.2237,0.0),xytext=(1.2237,-0.25),color='red',ha="center",fontsize=14,arrowprops=dict(arrowstyle="->",color='red',facecolor='red',lw='1'))


fig.tight_layout()
plt.savefig('ScienceFig3E.pdf')
plt.show()
