import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from matplotlib import colors
from matplotlib import ticker

fig, (ax1) = plt.subplots(nrows=1,ncols=1)
x0=np.loadtxt('./EOM-data/fortXvalues.dat',dtype='float')
y0=np.loadtxt('./EOM-data/V.txt',dtype='float')
X0,Y0= np.meshgrid(x0,y0)

Z1=np.loadtxt('./EOM-data/Ith.txt',dtype='float')
Z1.resize(81,21)
x1=np.loadtxt('./EOM-data/fortXvalues.dat',dtype='float')
y1=-np.loadtxt('./EOM-data/fortYvalues.dat',dtype='float')
X1,Y1= np.meshgrid(x1,y1)

divnorm=colors.TwoSlopeNorm(vmin=-1.2, vcenter=0., vmax=1.2)
d = ax1.pcolormesh(X1,Y1,100*Z1,cmap='bwr',shading='gouraud',rasterized=True,norm=divnorm)
clb = plt.colorbar(d,ax=ax1)
tick_locator = ticker.MaxNLocator(nbins=5)
clb.locator = tick_locator
clb.update_ticks()

clb.ax.set_title('$I_{th}$')
#ax1.set_title("$T/T_K=0.5$",loc='center')
ax1.set_xlabel('$g\mu_BB/k_BT_K$')
ax1.set_ylabel('$eV/k_BT_K$')
ax1.set_xlim(xmin=0.0,xmax=4.0)
ax1.set_ylim(ymin=-10.0,ymax=+10.0)
ax1.annotate(r'${\bf C}$',xy=(-0.1, 1.1), xycoords=ax1.transAxes)

fig.tight_layout()
plt.savefig('ScienceFig3C.pdf')
plt.show()
