README
======

Dataset title:  
    **Glacier surface elevation change trend dataset accompanying the article "Monthly surface elevation data of arctic mountain glaciers"**

Files:

- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__Alaska_Peninsula-Aleutians__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__Alaska_Range-Wrangell-Kilbuck__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__North_Alaska__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__North_Coast_Ranges__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__Saint_Elias_Mountains__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Alaska__West_Chugach_Mountains-Talkeetna__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__Axel_Heiberg_and_Meighen_Is__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__Devon_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__Melville_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__North_Central_Ellesmere_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__North_Ellesmere_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__South_Central_Ellesmere_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_North__South_Ellesmere_Island-Northwest_Devon__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__Bylot_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__Cumberland_Sound__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__East_Central_Baffin_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__Frobisher_Bay__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__North_Baffin_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__Northeast_Baffin_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__South_East_Baffin_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Arctic_Canada_South__West_Baffin_Island__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Greenland_Periphery__East_Greenland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Greenland_Periphery__North_Greenland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Greenland_Periphery__South_East_Greenland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Greenland_Periphery__South_West_Greenland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Greenland_Periphery__West_Greenland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Iceland__Iceland__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Russian_Arctic__Franz_Josef_Land__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Russian_Arctic__Novaya_Zemlya__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Russian_Arctic__Severnaya_Zemlya__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Scandinavia__all_subregions__500x500m__units_m_yr-1.tif`
- `Glacier_surface_elevation_change_rate_2010-2024__Svalbard_and_Jan_Mayen__Svalbard__500x500m__units_m_yr-1.tif`

The files of this dataset are formatted as geo-referenced TIFF files.
The distinctive parts of the file names refer to the first and second
order region names according to the Randolph Glacier Inventory (RGI)
version 7.0 \[1\]. The explicit file name format is:
Glacier_surface_elevation_change_rate_2010-2024__\<first order region
name\>__\<second order region name\>__500x500m__units_m_yr-1.tif. For
more information, please refer to the "Data" section below.

License: CC-BY-4.0

Contact: <j.m.haacker@tudelft.nl>

Summary
-------

Most glaciers currently decline because of the rapid climate change.
This dataset provides the glacier surface elevation change rates from
radar altimetry presented in the accompanied article. The dataset
includes all glaciers in the Arctic that are index in the Randolph
Glacier Inventory (RGI) version 7.0 \[1\]. The data are derived from the
European Space Agency's (ESA) mission CryoSat-2 \[2\], which is best
suited for glaciers covering several square kilometers. Where no
observations were available we interpolated using statistical methods.
The present dataset allows insights into dynamics of single glaciers, as
well as into regional or Arctic-wide trends.

The source data were provided by ESA.

Method
------

The open source Python software cryoswath equivalent to version 0.2.2
\[3\] was used to produce the data. It is based on the data published in
\[4\]. If you were to produce the data yourself, you could do so by
following the instructions below. If you do not have mamba available,
install it first \[5\] or use conda which works equivalently.

Create a folder, open a shell inside, and execute:

```shell
mamba create -n env_name conda-forge::"cryoswath=0.2.2"
mamba activate env_name
cryoswath-init
```

This creates to new folders: "data" and "scripts". Move the data of
\[4\] into the created folder "data/L3" and download
"build_trend_georaster.py" (included in this dataset) into scripts.
Importantly, in the "scripts" directory a file "config.ini" is created,
that includes the path to the base directory from which other pathes
will be resolved. Continue after switching into the "scripts" folder
with you prompt by executing:

`python build_trend_georaster.py <../data/L3/file of \[4\]> <../data/L4/output raster name.tif>`

You will be asked to download the RGI glacier outlines for each region
that you process into "data/auxiliary/RGI". The script
"build_trend_georaster.py" shows most details about the method. Please
refer to the associated article for anything further.

Data
----

The TIFF files contain variables in two bands named "trend" and
"trend_std".

Variables:

- "trend": The "trend" variable is stored on the first band. It contains
  the average surface elevation change rates in the period 2010 to 2024
  in units meter per year.
- "trend_std": The "trend_std" variable is stored on the second band. It
  contains the standard deviation of fit residuals and provides a
  statistical uncertainty estimate. Its units are meter per year.

References
----------

\[1\] RGI 7.0 Consortium, 2023. Randolph Glacier Inventory - A Dataset
    of Global Glacier Outlines, Version 7.0. NSIDC: NASA National Snow
    and Ice Data Center <https://doi.org/10.5067/F6JMOVY5NAVZ> (2023).  
\[2\] <https://www.eoportal.org/satellite-missions/cryosat-2>
\[3\] Haacker, J. cryoswath: v0.2.2. Zenodo
    <https://doi.org/10.5281/zenodo.15064780> (2025).  
\[4\] Haacker, Jan; Wouters, Bert: Glacier surface elevation
    dataset accompanying the article "Monthly surface elevation data of
    arctic mountain glaciers". Version 1. 4TU.ResearchData.
    <https://doi.org/10.4121/955d7f5a-0e3f-4166-a411-f0dcc4557cb2.v1>
    (2025)  
\[5\] <https://mamba.readthedocs.io/en/latest/installation/micromamba-installation.html>  
