This data set contains the data used to generate the main results, tables, and figures presented in the research paper titled "Combining astrometry and JUICE - Europa Clipper radio science to improve the ephemerides of the Galilean moons" (https://doi.org/10.1051/0004-6361/202347065). More detail on the exact analysis settings used to generate these results can therefore be found in the aforementioned paper. Three different types of files are provided, whose contents and file name conventions are described below.

### Correlations files

- correlations_combined.txt
- correlations_radioscience.txt

These two files contain the correlation matrices obtained from covariance analyses using either radio-science (simulated) data only or a combination of radio-science and existing astrometric observations (see publication for more detail). The size of the correlation matrices is nxn, n being the number of estimated parameters.

### Covariance files

- covariance_astrometry.dat
- covariance_radioscience.dat

These files contain the covariance matrices resulting from covariance analyses. One is obtained with existing astrometric observations only, the other from (simulated) radio-science measurements of the upcoming JUICE and Europa Clipper missions. The size of the covariance matrices is nxn, with n the number of estimated parameters.

### Propagated errors files

- propagatedErrorsRsw_astrometry.dat
- propagatedErrorsRsw_radioscience.dat
- propagatedErrorsRsw_combined.dat

The files contain the propagated covariance for the Galilean moons' estimated states. Each row starts with the time (in seconds since 2000) at which the covariance is computed, followed by the entries of the covariance matrix (concatenated row by row). The three aforementioned files respectively correspond to the cases where only astrometry, only radio-science, or a combination of both data is used to perform the covariance analysis (see publication for more detail).

- propagatedErrorsRsw_radioscience_missionTimeBounds.txt
- propagatedErrorsRsw_combined_missionTimeBounds.txt

These two files also contain the propagated covariance for the Galilean moons' estimated states, but the propagation is limited to the JUICE and Europa Clipper missions' timeline. The file format and naming convention are identical to the one described above.  
