% Simulate field and backscattered wave with MUST
clearvars

% define charactristics of transducer
param = getparam('P4-2v');

xe = ((1:param.Nelements)-param.Nelements/2)*param.pitch;
param.elements = [xe; zeros(1,length(xe))]; % position of the TX elements
% param.attenuation = 2.5e-4;
[txdel,param] = txdelay3(param,0,0); % send a plane wave to start with

% define the characteristics of the simulation
frequency = [1 2 2.5]*1e6;
RX_distance = 50e-3; % distance at which the receiver is placed 
RX_size = [1 2.5 5 10]*1e-3; % lateral size of the receiver assuming it is a square

rotation_theta_deg = 0:1:10; % rotation of the RX transducer according to Euler angles in degrees
rotation_psi_deg = 0;

lateral_shift_x = (0:0.5:10)*1e-3; % shift of centre of TX with respect to centre of RX in meters 
lateral_shift_y = 0; 

partitions_number = [1 2 4];


%% calculate the power at the location of interest

data_power_partitioning = zeros(length(RX_size)*length(frequency)*length(lateral_shift_x)*length(rotation_theta_deg)*length(partitions_number),12);
k=1;

for f = 1:length(frequency)
    param.fc = frequency(f);
    param.fs = 100*param.fc;

    for a = 1:length(RX_size)
        for lat_shift = 1:length(lateral_shift_x)
            for rotation = 1:length(rotation_theta_deg)
                          
                xf = lateral_shift_x(lat_shift); yf = lateral_shift_y; zf = RX_distance;
                disp(['Calculating frequency', num2str(frequency(f)/1e6), ' MHz, RX size ', num2str(RX_size(a)*1e3),' lateral shift mm', ...
                    num2str(xf*1e3)])
                        
                % generate the coordinates for the scatterers that are also used to calculate the US filed at the RX location
                coord_shift = rotate_vector_forward([xf yf zf], ...
                            [0 deg2rad(rotation_theta_deg(rotation)) deg2rad(rotation_psi_deg)]);
                lambda = param.c/param.fc;
                x_RX = linspace(-RX_size(a)/2,RX_size(a)/2,round(RX_size(a)/(lambda/5)));
                [xmatrix_RX,ymatrix_RX] = meshgrid(x_RX);
                
                xmatrix_RX = reshape(xmatrix_RX,[],1) - coord_shift(1);
                ymatrix_RX = reshape(ymatrix_RX,[],1) - coord_shift(2);
                zmatrix_RX = ones(length(xmatrix_RX),1)*coord_shift(3);
            
                % adjust the position of the scatterers depending on distance TX-RX and
                % tilt angle
                RX_coord = rotate_vector_forward([xmatrix_RX,ymatrix_RX,zmatrix_RX], ...
                                                           [0 deg2rad(rotation_theta_deg(rotation)) deg2rad(rotation_psi_deg)]);
                
        
    %             figure; scatter3(RX_coord(:,1),RX_coord(:,2),RX_coord(:,3),'filled') % check position of RX   
            
                % generate the coordinates to compute the US field
                x = linspace(-max(param.elements,[],'all')*1.5,max(param.elements,[],'all')*1.5,round(max(param.elements,[],'all')*2*1.5/(lambda/5))) - coord_shift(1);
                ymin = min(RX_coord(:,2)) - abs(min(RX_coord(:,2)))*0.5;
                ymax = max(RX_coord(:,2)) + abs(max(RX_coord(:,2)))*0.5;
                y = linspace(ymin,ymax,round(RX_size(a)*1.5/(lambda/5)));
                z = 0:1e-3:RX_distance*1.3;
            
                % obtain the the pressure in the azimuthal plane
                [xaz,zaz] = meshgrid(x,z);
                yaz = zeros(size(xaz));
                Paz = pfield(xaz,yaz,zaz,txdel,param);
            
                % Obtain the RMS pressure field on the elevation plane
                [yel,zel] = meshgrid(y,z);
                xel = ones(size(yel))*xf;
                Pel = pfield(xel,yel,zel,txdel,param);
            
                % Obtain the RMS pressure field on the focal plane
                % correct for the shift due to the angular tilt and lateral
                % misalignment
                [xfo,yfo] = meshgrid(x - coord_shift(1),y - coord_shift(2));
                zfo = ones(size(xfo))*coord_shift(3);
        
                xfo = reshape(xfo,[],1);
                yfo = reshape(yfo,[],1);
                zfo = reshape(zfo,[],1);
                xyzfo_coord = rotate_vector_forward([xfo yfo zfo], [0 deg2rad(rotation_theta_deg(rotation)) deg2rad(rotation_psi_deg)]);
        
                xfo = reshape(xyzfo_coord(:,1),[length(y),length(x)]);
                yfo = reshape(xyzfo_coord(:,2),[length(y),length(x)]);
                zfo = reshape(xyzfo_coord(:,3),[length(y),length(x)]);
        
                [Pfo,~,Pfo_ang] = pfield(xfo,yfo,zfo,txdel,param);
                index = determine_idx_2D(xfo,yfo,zfo,txdel,param); % get the index or the data to extract
                Pfo_ang = Pfo_ang(:,:,index); % extract the data of interest
        
        
                % need to have a mxn matrix so extract the correct value for each 
            
    %             Pmax = max(Paz(:));
    %             figure;
    %             surf(xaz,yaz,zaz,20*log10(Paz/Pmax)), shading flat
    %             hold on
    %             surf(xel,yel,zel,20*log10(Pel/Pmax)), shading flat
    %             surf(xfo,yfo,zfo,20*log10(Pfo/Pmax)), shading flat
    %             hold off
    %             % Fine-tune the figure:
    %             axis equal
    %             set(gca,'ZDir','reverse')
    %             title('US field generated by TX with plane wave focusing')
    %             zlabel('Distance from TX surface [m]')
    %             caxis([-20 0])
    %             alpha color
                       
            
                % calculate power at RX considering it is a single element
                % feed only the field values where the RX is placed 
                RX_position_shifted_x = unique(RX_coord(:,1)); % coordinates of the RX to have them correct even if it is shifted
                ROI_RX_x = find(unique(xfo)*1e4 >= min(RX_position_shifted_x)*1e4 & unique(xfo)*1e4 <= max(RX_position_shifted_x)*1e4);
                RX_position_shifted_y = unique(RX_coord(:,2));
                ROI_RX_y = find(unique(yfo)*1e4 >= min(RX_position_shifted_y)*1e4 & unique(yfo)*1e4 <= max(RX_position_shifted_y)*1e4);
                [mean_power_planewave_phase,mean_power_planewave_pkpk] = ...
                    calculate_power_simulation_MUST(Pfo_ang(ROI_RX_y,ROI_RX_x),RX_size(a),param,'n');
            
            
                %% simulate the RF signals with giving each scatterer a reflection coefficient of 1
                RF = simus3(RX_coord(:,1),RX_coord(:,2),RX_coord(:,3),ones(length(RX_coord(:,1)),1),txdel,param);
            
            %     % plot the receiver signals due to reflection at TX
    %             figure; 
    %             plot((RF(:,1:7:64)/max(RF(:))+(1:10))',(0:size(RF,1)-1)/param.fs*1e6,'k')
    %             set(gca,'XTick',1:10,'XTickLabel',int2str((1:7:64)'))
    %             title('RF signals')
    %             xlabel('Element number'), ylabel('time (\mus)')
    %             xlim([0 11])
    %             axis ij square
            
                % caclulate time difference between signals received by each element and
                % assign delay back to TX
                
                delay = zeros(3,size(RF,2));
                for i = 1:size(RF,2)
                    delay(1,i) = finddelay(RF(:,i),RF(:,1)); % find the delay between the signal with respect to the one received by the first element in the corner
                    delay(2,i) = finddelay(RF(:,i),RF(:,32));
                    delay(3,i) = finddelay(RF(:,i),RF(:,end));
                end
                
                % calculate the reversed delays to apply to the TX
                txdel_trev = mean(delay-min(delay,[],2))/param.fs; % these are the delays for the transducer with time reversal
            
                %% calculate the field again with the new delays
            
    %             Paz_trev = pfield(xaz,yaz,zaz,txdel_trev,param); % pressure in the azimuthal plane
    %             Pel_trev = pfield(xel,yel,zel,txdel_trev,param); % pressure in the elevation plane
                [Pfo_trev,~,Pfo_ang_trev] = pfield(xfo,yfo,zfo,txdel_trev,param); % pressure field on the focal plane
                index_trev = determine_idx_2D(xfo,yfo,zfo,txdel_trev,param); 
                Pfo_ang_trev = Pfo_ang_trev(:,:,index_trev); 
        
            
    %             Pmax_trev = max(Paz_trev(:));
    %             figure;
    %             surf(xaz,yaz,zaz,20*log10(Paz_trev/Pmax_trev)), shading flat
    %             hold on
    %             surf(xel,yel,zel,20*log10(Pel_trev/Pmax_trev)), shading flat
    %             surf(xfo,yfo,zfo,20*log10(Pfo_trev/Pmax_trev)), shading flat
    %             hold off
    %             % Fine-tune the figure:
    %             axis equal
    %             set(gca,'ZDir','reverse')
    %             title('US field generated by TX with time reversal focusing')
    %             zlabel('Distance from TX surface [m]')
    %             caxis([-20 0])
    %             alpha color
        %     % 
    %             figure
    %             surf(xfo,yfo,zfo,unwrap(angle(Pfo_ang_trev))), shading flat
%                 figure
%                 surf(xfo,yfo,zfo,Pfo_trev), shading flat
%                 hold on
%                 plot3([min(RX_coord(:,1)), max(RX_coord(:,1)), max(RX_coord(:,1)), min(RX_coord(:,1)), min(RX_coord(:,1))], ...
%                        [min(RX_coord(:,2)),min(RX_coord(:,2)),max(RX_coord(:,2)), max(RX_coord(:,2)), min(RX_coord(:,2))], ...
%                        [min(RX_coord(:,3)),min(RX_coord(:,3)),max(RX_coord(:,3)), max(RX_coord(:,3)), min(RX_coord(:,3))],'r')
%                 axis equal
%                 title(['timereversal ', num2str(RX_size(a)*1e3),' mm RX, lateral shift ', ...
%                     num2str(xf*1e3),'mm, tilt ', num2str(rotation_theta_deg(rotation))])
            
            
        %         RF_rev = simus3(RX_coord(:,1),RX_coord(:,2),RX_coord(:,3),ones(length(RX_coord(:,1)),1),txdel_trev,param);
            
                 % calculate power at RX considering it is a single element
                [mean_power_timereversal_phase,mean_power_timereversal_pkpk] = ...
                    calculate_power_simulation_MUST(Pfo_ang_trev(ROI_RX_y,ROI_RX_x),RX_size(a),param,'n');

                %% partition the RX
                for partitions_RX = partitions_number

                    % subdivide the RX points based on # of partitions
                    x_RX_points = xfo(ROI_RX_x);
                    y_RX_points = yfo(ROI_RX_y);

                    remainder_x = mod(length(x_RX_points),partitions_RX); % remaining measurement points after subdivision in partitions
                    remainder_y = mod(length(y_RX_points),partitions_RX);
                    pts_in_partition_x = floor(length(x_RX_points)/partitions_RX);
                    pts_in_partition_y = floor(length(y_RX_points)/partitions_RX);
                    subdivision_table = table(partitions_RX, pts_in_partition_x, remainder_x,...
                        pts_in_partition_y, remainder_y,'VariableNames',{'partitions','pt_in_partition_x','remainder_x',...
                        'pt_in_partition_y','remainder_y'});
        
                        % remove combinations in which less than two points in the measurements is
                        % available and when there are too many remainders
                        subdivision_table = subdivision_table(subdivision_table.pt_in_partition_x >= 2 & ...
                            subdivision_table.pt_in_partition_y >= 2 & subdivision_table.remainder_x < subdivision_table.partitions/3 & ...
                            subdivision_table.remainder_x < subdivision_table.partitions/3, :);

                        if height(subdivision_table) ~= 0
                        
                        size_partition_x = RX_size(a)/subdivision_table.partitions; % lateral size of the partition
                        size_partition_y = size_partition_x;
                         % add one more measurement point to the partition if there is a remainder from the division
                
                        partition_allocation_x = repmat(subdivision_table.pt_in_partition_x,1,subdivision_table.partitions); % this is the ideal distribution of the point when there is no remainder from the division
                        partition_allocation_x(round(linspace(1,subdivision_table.partitions,subdivision_table.remainder_x))) = ...
                            partition_allocation_x(round(linspace(1,subdivision_table.partitions,subdivision_table.remainder_x))) + 1;
    
                        partition_allocation_y = repmat(subdivision_table.pt_in_partition_y,1,subdivision_table.partitions); % this is the ideal distribution of the point when there is no remainder from the division
                        partition_allocation_y(round(linspace(1,subdivision_table.partitions,subdivision_table.remainder_y))) = ...
                            partition_allocation_y(round(linspace(1,subdivision_table.partitions,subdivision_table.remainder_y))) + 1;
    
                        % subdivide the data into the partitions 
                        sub_array = mat2cell(Pfo_ang_trev(ROI_RX_y,ROI_RX_x),partition_allocation_y,partition_allocation_x);
                    
                        mean_power_partition_phase = zeros(size(sub_array));
                        mean_power_partition_pkpk = zeros(size(sub_array));
                        for b = 1:size(sub_array,1)
                            for c = 1:size(sub_array,2)
                                % calculate the power in each of the paritions 
                                [mean_power_partition_phase(b,c), mean_power_partition_pkpk(b,c)] = ...
                                    calculate_power_simulation_MUST(sub_array{b,c},size_partition_x,param,'n');
                            end
                        end
    
                        % summarize results in table        
                        data_power_partitioning(k,:) = [frequency(f), RX_size(a), xf, rotation_theta_deg(rotation),...
                            sum(mean_power_planewave_pkpk,'all'), sum(mean_power_planewave_phase,'all'),...
                            sum(mean_power_timereversal_pkpk,'all'), sum(mean_power_timereversal_phase,'all'),...
                            subdivision_table.partitions, size_partition_x,...
                            sum(mean_power_partition_pkpk,'all'), sum(mean_power_partition_phase,'all')];
                        k=k+1;
                    else 
                        continue
                    end
                end
            end
        end
    end
end


%

data_table = array2table(data_power_partitioning,'VariableNames',{'frequency','size_RX','lat_shift','phi_rotation',...
                            'power_planewave_pkpk','power_planewave_phase',...
                            'power_timerev_pkpk','power_timerev_phase',...
                            'number_partitions','size_partition','power_partition_pkpk','power_partition_phase'});
data_table = data_table(1:k-1,:); % remove empty rows if we skipped some iterations with the partitioning 

data_table.size_partition_lambda = data_table.size_partition./(param.c./data_table.frequency);
data_table.ratioTX_RX = (data_table.size_RX./abs(max(param.elements(1,:))-min(param.elements(1,:))));
% ./(param.c./data_table.frequency);



for i = 1:length(frequency)
    subtable_freq = data_table(data_table.frequency == frequency(i),:);
    unique_partitions = unique(subtable_freq.number_partitions);
    figure;
    for j = 1:length(unique_partitions)
        subtable = subtable_freq(subtable_freq.number_partitions == unique_partitions(j),:);
        [~,max_timerev_power_idx] = max(subtable.power_timerev_phase);
        normalised_improvement_lateral = subtable.power_timerev_phase./subtable.power_timerev_phase(max_timerev_power_idx);
        [~,max_part_power_idx] = max(subtable.power_partition_phase);
        normalised_improvement_part_lateral = subtable.power_partition_phase./subtable.power_partition_phase(max_part_power_idx);
        plot(subtable.lat_shift*1e3,normalised_improvement_lateral,'DisplayName','trev')
        hold on
        plot(subtable.lat_shift*1e3,normalised_improvement_part_lateral,'DisplayName',['trev+part ',num2str(subtable.size_partition_lambda(1)),'\lambda'])
    end
end
xlabel('Lateral shift [mm]')
ylabel('Normalised improvement')
legend('Location','bestoutside')


% for i = 1:length(frequency)
%     subtable_freq = data_table(data_table.frequency == frequency(i),:);
%     for j = 1:length(RX_size)
%         figure;
%         subtable = subtable_freq(subtable_freq.size_RX == RX_size(j),:);
% %         normalised_improvement_angle = subtable.power_timerev_phase./subtable.power_timerev_phase(subtable.phi_rotation == 0);
%         normalised_improvement_lateral = subtable.power_timerev_phase./subtable.power_timerev_phase(subtable.lat_shift == 0);
%         % normal_tilt_power_angle = subtable.power_focus_phase./subtable.power_focus_phase(subtable.phi_rotation == 0);
%         normal_tilt_power_lateral = subtable.power_focus_phase./subtable.power_focus_phase(subtable.lat_shift == 0);
%         
%         % plot(subtable.phi_rotation,normalised_improvement_angle)
%         plot(subtable.lat_shift*1e3,normalised_improvement_lateral,'DisplayName',...
%             ['timerev, f=',num2str(frequency(i)),'RX ',num2str(subtable.lambda_RX(1)),'\lambda'])
%         hold on
%         % plot(subtable.phi_rotation,normal_tilt_power_angle)
% %         plot(subtable.lat_shift*1e3,normal_tilt_power_lateral,'DisplayName',['focus, f=',num2str(frequency(i))])
%     end
% end
% xlabel('Lateral shift [mm]')
% ylabel('Normalised improvement')
% legend('Location','bestoutside')
% 
% 
wavelengths_ratios = unique(data_table.ratioTX_RX);
figure;
for i = 1:length(wavelengths_ratios)
    subtable = data_table(data_table.ratioTX_RX == wavelengths_ratios(i),:);
    unique_frequencies = unique(subtable.frequency);
    for j =1:length(unique_frequencies)
        subtable_freq = subtable(subtable.frequency == unique_frequencies(j),:);
        [~,max_timerev_power_idx] = max(subtable_freq.power_timerev_phase);
        normalised_improvement_lateral = subtable_freq.power_timerev_phase./subtable_freq.power_timerev_phase(max_timerev_power_idx);
%         normal_tilt_power_lateral = subtable_freq.power_focus_phase./subtable_freq.power_focus_phase(subtable_freq.lat_shift == 0);
        
        plot(subtable_freq.lat_shift*1e3,normalised_improvement_lateral,'DisplayName',...
            ['timerev, f ',num2str(subtable.frequency(j)/1e6),' ratio ',num2str(wavelengths_ratios(i)),'\lambda'])
        hold on
    end
end
xlabel('Lateral shift [mm]')
ylabel('Normalised improvement')
legend('Location','bestoutside')

colors = [240 91 134;...
          66 197 184;...
          191 224 110]./255;

for i = 1:length(frequency)
    subtable_freq = data_table(data_table.frequency == frequency(i),:);
    for j = 1:length(RX_size)
        figure;
        subtable = subtable_freq(subtable_freq.size_RX == RX_size(j),:);
        unique_partitions = unique(subtable.number_partitions);
        for m = 1:length(unique_partitions)
            subtable_partition = subtable(subtable.number_partitions == unique_partitions(m),:);

            unique_lat_shift = unique(subtable_partition.lat_shift);
            unique_angle = unique(subtable_partition.phi_rotation);
            lat_shift_matrix = reshape(subtable_partition.lat_shift,length(unique_angle),length(unique_lat_shift));
            rot_matrix = reshape(subtable_partition.phi_rotation,length(unique_angle),length(unique_lat_shift));

            power_matrix = reshape(subtable_partition.power_partition_phase,length(unique_angle),length(unique_lat_shift));
            power_matrix = power_matrix;
%             ./max(power_matrix,[],"all");

            surf(lat_shift_matrix*1e3,rot_matrix,power_matrix,'FaceColor',colors(m,:),'EdgeAlpha',0.1,...
                'DisplayName',num2str(unique_partitions(m)))
            hold on
        end
            view(-45,15)
            set(gca,'YDir','reverse')
            xlabel('Lateral shift [mm]')
            ylabel('Angle rotation [deg]')
            zlabel('Normalised improvement')
%             legend('Location','bestoutside')
            title(['f= ',num2str(frequency(i)/1e6),', RX size = ',num2str(RX_size(j)*1e3)])
    end
end

set(gcf,'renderer','painters');


            







