%% this script processes the pressure data from the hydrophone 
clearvars


% after copying the data in the right folder, execute the script that
% processes the data "processDataGeneral.mat"in EMLab

%then import hte mat file containing the extracted data
frequency = 2.5;   % enter the frequency in MHz
[filename,pathname] = uigetfile('C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\EM_lab_processed_data\*.mat','Select the mat file containing the data');

load(strcat(pathname,filename));
acoustic_data = acoustic{1,2};
acoustic_info_exp = acoustic{1,1};
clearvars acoustic

%%
% find number of rows matrix
rows = length(find(arrayfun(@(x) acoustic_data(x).Y == 0, 1:numel(acoustic_data))));
col = find(diff([acoustic_data.Z]'),1);
% dim3 = length(unique([acoustic_data.X]'));

% extract the matrices of the measurement position and the pkpk value 
z_matrix  = transpose(reshape([acoustic_data.Z]',col,rows));
y_matrix  = transpose(reshape([acoustic_data.Y]',col,rows));
% x_matrix  = [acoustic_data.X]';
voltage_matrix = transpose(reshape([acoustic_data.sourcepp]',col,rows)); % extracts the Vpp of the line vector which containes the volatge signal of the hidrophone to be transformed in pressure
vin_matrix = transpose(reshape([acoustic_data.signalpp]',col,rows)); % extracts the Vpp of the input signal to the transducer

% rearranges the data in the matrix 
for k = 2:2:rows
    voltage_matrix(k,:) = fliplr(voltage_matrix(k,:));
    vin_matrix(k,:) = fliplr(vin_matrix(k,:));
    y_matrix(k,:) = fliplr(y_matrix(k,:));
end

needle = acoustic_info_exp.needle.data;

% find the sensitivity of the needle at that frequency
total_sensitivity = needle{1, 2}.sens_needle;
[~, sensitivity_index] = min(abs(frequency-needle{1, 2}.freq_needle)); % find the closest frequency of the calibrated ones to the actual measuring frequency
sensitivity = total_sensitivity(sensitivity_index); % sensitivity = mV/MPa


% calculate pressure and intensity 
% the pressure from the hydrophone is the peak to peak pressure
pressure = (voltage_matrix.*10^(3))./sensitivity;    % pressure in MPa  (multiply voltage by 10^3 to have mV)

% calculate voltage sweep coefficient 
coeffs = polyfit(vin_matrix*10,pressure,1);

figure
plot(vin_matrix*10,pressure,'.-','linewidth', 1.5,'MarkerSize',20) % input voltage has to be multiplied by 10 if a 10:1 probe is used to measure
grid on
xlabel('Input voltage at the trasnducer [V]')
ylabel('Output peak-to-peak pressure [MPa]')
dim = [.2 .5 .3 .3];
str = ['y = ',num2str(coeffs(1)),'x + ',num2str(coeffs(2))];
annotation('textbox',dim,'String',str,'FitBoxToText','on');



% 
% %% precise calculation
% 
% diam_drum = 85e-6;
% radius_drum = diam_drum/2;
% drum_pcolumn = 56;
% drum_rows = 6;
% num_drums = drum_pcolumn * drum_rows;
% 
% % calculates the dimensions of the packing in which the CMUTs are arranged
% height_packing = (2*drum_pcolumn+1)*radius_drum;
% width_packing = (2 + (drum_rows -1)*sqrt(3))*radius_drum;
% area_occupied = height_packing * width_packing; % area occupied by the packing 
% 
% % position of the centers of the drums 
% 
% x_center = linspace(-width_packing/2+radius_drum,width_packing/2-radius_drum,drum_rows)';
% y_center = linspace(-height_packing/2+radius_drum,height_packing/2-radius_drum,drum_pcolumn)';
% 
% [x_mesh,y_mesh] = meshgrid(x_center,y_center);
% 
% for k = 2:2:drum_rows
%     y_mesh(:,k) = y_mesh(:,k)-radius_drum;
% end
% 
% % builds teh array of the position of the centers of the drums 
% 
% z_center_total = reshape(y_mesh,[],1);
% y_center_total = reshape(x_mesh,[],1);
% center_drums = [y_center_total z_center_total];
% 
% %% build an interpolant function
% 
% y_array = reshape(y_matrix,[],1)*1e-3;
% z_array = reshape(z_matrix,[],1)*1e-3;
% intensity_array = reshape(intensity,[],1);
% 
% F = scatteredInterpolant(y_array,z_array,intensity_array);
% %% evaluate the interpolant in the center of the drums
% 
% intensity_interp = F(y_center_total,z_center_total);
% 
% % plots the pressure values 
% % figure
% % plot3(y_array,z_array,F(y_array,z_array),'o')
% % grid on
% % hold on
% % plot3(y_center_total,z_center_total,intensity_interp,'o')
% % legend('measured pressure','extrapolated pressure','location','best')
% % zlabel('Intensity [W/m^2]')
% 
% %% calculate the efficiency
% mean_total_intensity = mean(intensity_interp);
% % mean_total_pressure = mean(acoustic.SourcePeakPeak.*1e9./sensitivity)/sqrt(8)
% mean_total_pressure = mean(mean(pressure/2))
% power_US = mean_total_intensity*area_occupied % the area occupied is a pi/(2+sqrt(3)) fraction of that area 
% 
% Efficiency = max_power/power_US*100  
% %%
% 
% % rearrange the interpolated intensity in a matrix
% intensity_interp_matrix = reshape(intensity_interp,56,6);
% 
% 
% figure
% % surf(y_interp_grid*1e-3,z_interp_grid*1e-3,pressure_interp,'edgecolor','interp')
% surf(x_mesh,y_mesh,intensity_interp_matrix,'edgecolor','interp')
% xlabel('Width [m]')
% ylabel('Height [m]')
% xlim([min(y_center_total)-radius_drum max(y_center_total)+radius_drum])
% ylim([min(z_center_total)-radius_drum max(z_center_total)+radius_drum])
% hp = colorbar;
% 
% ylabel(hp,'W/m^2')
% title(['Intensity at CMUT surface, ', num2str(frequency),'MHz'])
% hold on
% viscircles(center_drums,radius_drum*ones(num_drums,1),'EnhanceVisibility',false,'linewidth',1.5);
% daspect([1 1 350000])
% % imagesc(y_interp*1e-3,z_interp*1e-3,pressure_interp)
% imagesc([min(y_center_total)-radius_drum max(y_center_total)+radius_drum],[min(z_center_total)-radius_drum max(z_center_total)+radius_drum],intensity_interp_matrix)
% % rectangle('position',[-width_packing/2-radius_drum -height_packing/2-2*radius_drum width_packing+2*radius_drum height_packing+3*radius_drum])
% % set(gca,'FontName','Arial','FontSize',18)
% 
% %% calculate feasibility in humans
% 
% % take max pressure value, therefore divide by 2 since it's pkpk what is
% % measured
% z_0 = 993*1515; % rho*c
% TBD = 10/frequency; %10 cycles of burst
% PRF = 10;
% % pulse intensity integral
% PII = (pressure/2*1e6).^2*TBD/(2*z_0);  
% 
% Isppa = PII/TBD*1e-4; % in W/cm^2
% Ispta = PII*PRF*1e-4; % in W/cm^2
% 
% max_Isppa = max(max(Isppa)) % in W/cm^2
% max_Ispta = max(max(Ispta))*1e3 % in mW/cm^2
% MI = max(max(pressure/2))/sqrt(frequency)

