 with this script the data from the pressure profile measurements are analysed
% and the power for different sizes of the RX is calcluated
clearvars;

% define the varibales of the TX transducer
frequency =1e6; % frequency of the simulation

% define the variables of the RX transducer
RX_x = 5*1e-3; % dimension of RX in x coordinate
RX_y = 5*1e-3; % dimension of RX in y coordinate
test_distance = 110*1e-3; % distance at which to perform the simulation in meters
test_voltage_TX = 52; % input voltage at TX during power transfer experiment 


medium = set_medium('water');
lateral_step = 1e-3; % this is the step from the measurement data 

%% load the data from the hydrophone measurements 

% measured data to the pressure at the desired driving voltage 
[filename,pathname] = uigetfile('C:\Users\320033994\OneDrive - Philips\Power transfer\Experiments\US vs inductive benchmarking\EM_lab_processed_data\*.mat','Select the mat file containing the data');

load(strcat(pathname,filename));
acoustic_data = acoustic{1,2};
acoustic_info_exp = acoustic{1,1};
% clearvars acoustic



%% calculate the average power at the receiver
mean_power_measurement_phase = zeros(length(RX_x),1);
mean_power_measurement_pkpk = zeros(length(RX_x),1);
mean_pressure_measurement = zeros(length(RX_x),1);

for i = 1:length(RX_x)

    % find the indices of the data corresponding to the area 
    ROI_indices = find(abs([acoustic_data.Z])'<= RX_x(i)*1e3/2 & abs([acoustic_data.Y])'<= RX_y(i)*1e3/2);
    rows_ROI = length(find([acoustic_data(ROI_indices).Y]' == 0)); % determine the number of rows and columns in the region of interest
    col_ROI = find(diff([acoustic_data(ROI_indices).Z]'),1);
    
    voltage_matrix_ROI = transpose(reshape([{acoustic_data(ROI_indices).line}]',col_ROI,rows_ROI)); % extracts the signal recorded at each point of the selected region of interest. 
    % Each cell contains the recording 
    vin_matrix = [acoustic_data(ROI_indices).signalpp];    
    pressure_scaling_coeff = test_voltage_TX/ (vin_matrix(1)*10);
    
    % find the sensitivity of the needle at that frequency
    needle = acoustic_info_exp.needle.data;
    total_sensitivity = needle{1, 2}.sens_needle;
    [~, sensitivity_index] = min(abs(frequency/1e6 - needle{1, 2}.freq_needle)); % find the closest frequency of the calibrated ones to the actual measuring frequency
    sensitivity = total_sensitivity(sensitivity_index); % sensitivity = mV/MPa
    
    % calculate the power at the receiver 
    [mean_power_measurement_phase(i), mean_power_measurement_pkpk(i), mean_pressure_measurement(i)] = ...
        calculate_power_measurements(rows_ROI,col_ROI,voltage_matrix_ROI,sensitivity,...
                                            frequency,medium,pressure_scaling_coeff,RX_x(i),RX_y(i),'n');
end

% figure
% % yyaxis left
% plot(RX_x*1e3,mean_power_measurement_pkpk*1e3,Marker=".")
% hold on
% plot(RX_x*1e3,mean_power_measurement_phase*1e3,Marker=".")
% xlabel('Lateral size receiver [mm]')
% ylabel('Power at RX [mW]')
(mean_power_measurement_phase(1)./(RX_x(1).^2))/10 % intensity
% 
% figure
% % yyaxis left
% plot(RX_x*1e3,mean_pressure_measurement,Marker=".")
% xlabel('Lateral size receiver [mm]')
% ylabel(['Pressure at RX [MPa]'])
% % xlim([4.95 5.05])
mean_pressure_measurement

% yyaxis right
% plot(sub_data_sim.RX_lat_size,sub_data_sim.simulation_power_ratio)
% hold on
% scatter(RX_x*1e3,measurement_power_ratio)
% legend('50 mm pkpk', '50 mm phase', '100 mm pkpk', '100 mm phase', '181 mm pkpk', '181 mm phase','Location','northwest')
