function [max_optim_power_phase,z_best] = calculate_power_distance_MUST(xf,yf,zf,ROI_RX_y,ROI_RX_x,RX_size,param)

% % calculate the ultrasound field for each distance to later on determine at which focusing distance the maximum power is achieved 

mean_power_optim_phase = zeros(length(z),1);
lambda = param.c/param.fc;
x = linspace(-max(param.elements,[],'all')*1.5,max(param.elements,[],'all')*1.5,round(max(param.elements,[],'all')*2*1.5/(lambda/5)));
y = linspace(-RX_size/2*1.5,RX_size/2*1.5,round(RX_size*1.5/(lambda/5)));
z = zf*0.6:1e-3:param.focus*2.5;

[xfo,yfo] = meshgrid(x,y);
zfo = ones(size(xfo))*zf;

for i = 1:length(z)
    % calculates the delay
    txdel_optim = txdelay3(xf,yf,z(i),param);
    [~,~,Pfo_ang_optim] = pfield(xfo,yfo,zfo,txdel_optim,param);
    index_optim = determine_idx_2D(xfo,yfo,zfo,txdel_optim,param); % get the index or the data to extract
    Pfo_ang_optim = Pfo_ang_optim(:,:,index_optim); % extract the data of interest
    [mean_power_optim_phase(i),~] = ...
        calculate_power_simulation_MUST(Pfo_ang_optim(ROI_RX_y,ROI_RX_x),RX_size,param,'n');
end

% find the optimum power 
[max_optim_power_phase, idx_max_power] = max(mean_power_optim_phase);
z_best = z(idx_max_power);

end