function [mean_power_simulation_phase, mean_power_simulation] = calculate_power_simulation_CW(frequency,medium,ROI_pressure_simulation,RX_x,RX_y,figure_show)
%calculate_power_simulation_CW calculates the power at the receiver with
%both only taking into account the peak-to-peak value and with taking into
%account the phase

%   figure_show = 'y' shows the sine waves for each point in the area of
%   the RX
%   mean_power_simulation_phase: is the average power at the receiver
%   calculated by coherently averaging the pressur signal over the area
%   mean_power_simulation: is the average power at the reciver calculated
%   by averaging only the peak to peak values of the pressure signal
    
    t = linspace(0,2/frequency,500); % build an array with the size of 2 periods
    total_pressure_simulation = zeros(numel(ROI_pressure_simulation),length(t));
    pp_pressure_simulation = zeros(size(ROI_pressure_simulation,1),size(ROI_pressure_simulation,2));
    k=1;
    
%     h = figure('visible','off');

    for i = 1:size(ROI_pressure_simulation,1)
        for j = 1:size(ROI_pressure_simulation,2)
            % convert the pressure value from imaginary to sine wave for the 0,0 point
            [theta, rho] = cart2pol(real(ROI_pressure_simulation(i,j)),imag(ROI_pressure_simulation(i,j)));
            total_pressure_simulation(k,:) = rho*sqrt(2)*sin(2*pi*frequency*t+theta);
            pp_pressure_simulation(i,j) = max(total_pressure_simulation(k,:))-min(total_pressure_simulation(k,:)); % this is the peak to peak pressure
            
%             plot(t,total_pressure_simulation(k,:))
%             hold on
            k=k+1;
        end
    end
    
    
    mean_pressure_simulation_phase = mean(total_pressure_simulation); % calculate the mean pressure of the simulation taking into account the phase
    
%     plot(t,mean_pressure_simulation_phase,'k','linewidth',2)
%     if strcmp(figure_show,'y')
%         set(h, 'visible', 'on'); 
%     end

    
    mean_intensity_simulation_phase = (max(mean_pressure_simulation_phase)-min(mean_pressure_simulation_phase)).^2/...
                                        (8*medium.density*medium.soundspeed);
    mean_power_simulation_phase = mean_intensity_simulation_phase * RX_x * RX_y;
    
    % calculate the incoming power only considering the peak to peak values 
    mean_pressure_simulation = mean(pp_pressure_simulation,'all');
    mean_intensity_simulation = mean_pressure_simulation^2/(8*medium.density*medium.soundspeed);
    mean_power_simulation = mean_intensity_simulation * RX_x * RX_y;

%     plot of the entire ultrasound field 
%     figure();
%     h = pcolor(pp_pressure_simulation);
%     set(h,'edgecolor','none');
%     title('Pressure Field at y = 0 cm');
%     xlabel('x (mm)');
%     ylabel('z (mm)');
%     daspect([1, 1, 1])
end