function [Pfo_ang_optim,x,y,z] = calculate_power_distance_MUST(xf,yf,zf,RX_size,param)

% % calculate the ultrasound field for each distance to later on determine at which focusing distance the maximum power is achieved 


lambda = param.c/param.fc;
x = linspace(-max(param.elements,[],'all')*1.5,max(param.elements,[],'all')*1.5,round(max(param.elements,[],'all')*2*1.5/(lambda/5)));
y = linspace(-RX_size/2*1.5+yf,RX_size/2*1.5+yf,round(RX_size*1.5/(lambda/5)));
z = zf*0.6:1e-3:150e-3;
Pfo_ang_optim = zeros(length(y),length(x),length(z));

% computes the power at the location (plane) of the RX
[xfo,yfo] = meshgrid(x,y);
zfo = ones(size(xfo))*zf; 
option.WaitBar = false; 

for i = 1:length(z)
    % calculates the delay    
    txdel_optim = txdelay3(xf,yf,z(i),param); % focuses on different planes 
    [~,~,Pfo_ang] = pfield(xfo,yfo,zfo,txdel_optim,param,option);
    index_optim = determine_idx_2D(xfo,yfo,zfo,txdel_optim,param); % get the index of the data to extract
    Pfo_ang_optim(:,:,i) = Pfo_ang(:,:,index_optim); % extract the data of interest
    
end

end