// This file is automatically generated - DO NOT EDIT MANUALLY!
using System.Collections.Generic;
using Unity.MARS.Query;

namespace Unity.MARS.Data
{
    public partial class MARSDatabase
    {
        bool FindRelationTraits(Relations relations, RelationTraitCache cache)
        {
            if (relations.GetTypeCount(out IRelation<System.Int32>[] intRelations) > 0)
            {
                if (!cache.TryGetType(out List<RelationTraitCache.ChildTraits<System.Int32>> intTraits))
                    return false;

                if (!FindTraitCollections(IntTraitProvider, intRelations, intTraits))
                    return false;
            }

            if (relations.GetTypeCount(out IRelation<UnityEngine.Pose>[] poseRelations) > 0)
            {
                if (!cache.TryGetType(out List<RelationTraitCache.ChildTraits<UnityEngine.Pose>> poseTraits))
                    return false;

                if (!FindTraitCollections(PoseTraitProvider, poseRelations, poseTraits))
                    return false;
            }

            if (relations.GetTypeCount(out IRelation<UnityEngine.Vector2>[] vector2Relations) > 0)
            {
                if (!cache.TryGetType(out List<RelationTraitCache.ChildTraits<UnityEngine.Vector2>> vector2Traits))
                    return false;

                if (!FindTraitCollections(Vector2TraitProvider, vector2Relations, vector2Traits))
                    return false;
            }

            return true;
        }

        bool DataStillMatches(Dictionary<IMRObject, int> dataAssignments, Relations relations,
            Dictionary<IMRObject, SetChildArgs> children, HashSet<IMRObject> nonRequiredChildrenLost)
        {
            if (relations.TryGetType(out IRelation<System.Int32>[] intRelations) && intRelations.Length > 0)
            {
                if (!CheckIfDataStillMatches(dataAssignments, intRelations, IntTraitProvider, 
                    children, nonRequiredChildrenLost))
                    return false;
            }

            if (relations.TryGetType(out IRelation<UnityEngine.Pose>[] poseRelations) && poseRelations.Length > 0)
            {
                if (!CheckIfDataStillMatches(dataAssignments, poseRelations, PoseTraitProvider, 
                    children, nonRequiredChildrenLost))
                    return false;
            }

            if (relations.TryGetType(out IRelation<UnityEngine.Vector2>[] vector2Relations) && vector2Relations.Length > 0)
            {
                if (!CheckIfDataStillMatches(dataAssignments, vector2Relations, Vector2TraitProvider, 
                    children, nonRequiredChildrenLost))
                    return false;
            }

            return true;
        }

        void FillRelationTraits(Dictionary<IMRObject, int> dataAssignments,
            Relations relations, Dictionary<IMRObject, QueryResult> childResults)
        {
            if (relations.TryGetType(out IRelation<System.Int32>[] intRelations) && intRelations.Length > 0)
            {
                foreach (var relation in intRelations)
                {
                    var child1 = relation.child1;
                    if (childResults.TryGetValue(child1, out var child1Result))
                    {
                        var trait1Name = relation.child1TraitName;
                        IntTraitProvider.TryGetTraitValue(dataAssignments[child1], trait1Name, out var value1);
                        child1Result.SetTrait(trait1Name, value1);
                    }

                    var child2 = relation.child2;
                    if (childResults.TryGetValue(child2, out var child2Result))
                    {
                        var trait2Name = relation.child2TraitName;
                        IntTraitProvider.TryGetTraitValue(dataAssignments[child2], trait2Name, out var value2);
                        child2Result.SetTrait(trait2Name, value2);
                    }
                }
            }

            if (relations.TryGetType(out IRelation<UnityEngine.Vector2>[] vector2Relations) && vector2Relations.Length > 0)
            {
                foreach (var relation in vector2Relations)
                {
                    var child1 = relation.child1;
                    if (childResults.TryGetValue(child1, out var child1Result))
                    {
                        var trait1Name = relation.child1TraitName;
                        Vector2TraitProvider.TryGetTraitValue(dataAssignments[child1], trait1Name, out var value1);
                        child1Result.SetTrait(trait1Name, value1);
                    }

                    var child2 = relation.child2;
                    if (childResults.TryGetValue(child2, out var child2Result))
                    {
                        var trait2Name = relation.child2TraitName;
                        Vector2TraitProvider.TryGetTraitValue(dataAssignments[child2], trait2Name, out var value2);
                        child2Result.SetTrait(trait2Name, value2);
                    }
                }
            }
        }
    }
}
