%This file creates plain versions of all the plots in the paper. Additional
%formatting (such as labels inside the graphs) was added manually.
%Follow the instructions and run the code in portions to generate each figure
%separately.


%In order to create Figure 6 (Modal shares and VKT depending on the private travel benefit B), 
% comment the following lines in the file Solver: 22-69.
% The remaining lines (aside from descriptions) should be active.

%In order to create Figure 6, left (Modal shares)
plot(B_VECTOR,P_PT1,'Color',[0.4660 0.6740 0.1880],'LineWidth',0.75)
hold on
plot(B_VECTOR,P_PT2,'--','Color',[0.4660 0.6740 0.1880],'LineWidth',0.75)
hold on
plot(B_VECTOR,P_A1,'Color',[0.6350 0.0780 0.1840],'LineWidth',0.75)
hold on
plot(B_VECTOR,P_A2,'--','Color',[0.6350 0.0780 0.1840],'LineWidth',0.75)
hold on
plot(B_VECTOR,P_SAV2,'--','Color',[0 0.4470 0.7410],'LineWidth',0.75)
hold off
xlim([4 20])
ylim([0 1])
xlabel('Private travel benefit') 
ylabel('Modal shares')

%In order to create Figure 6, right (VKT per passenger)
plot(B_VECTOR,V1,'Color',[0,0,0],'LineWidth',0.75)
hold on
plot(B_VECTOR,V2,'--','Color',[0,0,0],'LineWidth',0.75)
hold off
xlim([4 20])
ylim([3 9])
xlabel('Private travel benefit') 
ylabel('VKT per passenger')



%In order to create Figure 8 (Modal shares and VKT depending on SAV
%capacity) and Figure 9 (VKT depending on the functional forms of f(K_SAV)), 
% comment the following lines in the file Solver: %71-106.
% The remaining lines (aside from descriptions) should be active.

n = size(K_SAV_VECTOR,2);

%In order to create Figure 8, left (Modal shares)
plot(K_SAV_VECTOR(2:n),P_PT1(2:n),'Color',[0.4660 0.6740 0.1880],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),P_PT2(2:n),'--.','Color',[0.4660 0.6740 0.1880],'LineWidth',0.75)
hold on
plot(K_SAV_VECTOR(2:n),P_A1(2:n),'Color',[0.6350 0.0780 0.1840],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),P_A2(2:n),'--.','Color',[0.6350 0.0780 0.1840],'LineWidth',0.75)
hold on
plot(K_SAV_VECTOR(2:n),P_SAV2(2:n),'--.','Color',[0 0.4470 0.7410],'LineWidth',0.75)
hold off
xlim([3 12])
ylim([0 1])
xlabel('K_{SAV}') 
ylabel('Modal shares')

%In order to create Figure 8, right (VKT per passenger)
plot(K_SAV_VECTOR(2:n),V1(2:n),'Color',[0,0,0],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),V2(2:n),'--.','Color',[0,0,0],'LineWidth',0.75)
hold off
xlim([3 12])
ylim([7.2 8])
xlabel('K_{SAV}') 
ylabel('VKT per passenger')


%In order to create Figure 9, left (VKT per passenger)
plot(K_SAV_VECTOR(2:n),V1(2:n),'Color',[0 0 0],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),V2(2:n),'--.','Color',[0 0 0],'LineWidth',0.75)
hold on
plot(K_SAV_VECTOR(2:n),V2_f2(2:n),'--.','Color',[0.8500 0.3250 0.0980],'LineWidth',0.75)
hold on
plot(K_SAV_VECTOR(2:n),V2_f3(2:n),'--.','Color',[0.4940 0.1840 0.5560],'LineWidth',0.75)
hold off
xlim([3 12])
ylim([6.5 8.2])
xlabel('K_{SAV}') 
ylabel('VKT per passenger')

%In order to create Figure 9, right (functional forms of f)
plot(K_SAV_VECTOR(2:n),FVector(1:n-1,1),'Color',[0 0 0],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),FVector(1:n-1,2),'Color',[0.8500 0.3250 0.0980],'LineWidth',0.75,'Marker','.')
hold on
plot(K_SAV_VECTOR(2:n),FVector(1:n-1,3),'Color',[0.4940 0.1840 0.5560],'LineWidth',0.75,'Marker','.')
hold off
xlim([3 12])
ylim([0.25 0.55])
xlabel('K_{SAV}') 
ylabel('f(K_{SAV})') 

