# -*- coding: utf-8 -*-
"""
Created on Tue Sep 24 19:52:47 2019

@author: PezijM1
"""

# import packages
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

# close all current matplotlib plots
plt.close("all")

# set latex interpreter
latex = 1
if latex == 1:
    plt.rc('text', usetex=True)
    plt.rc('font', family='serif')

# define input name
fName = r"rmse_full.csv"

# define locations to analyse
insit_loc = [1, 3, 6, 8, 9, 10, 12, 13, 14, 15, 16]
ix_plot = [x+1 for x in insit_loc]

# read assessment data
df = pd.read_excel(fName,
                   index_col=[0],
                   na_values=-9999)

# get RMSE values
rmse_sim_loc = [df["insitu"][i] for i in ix_plot]
rmse_sim_loc2016 = [df["2016_insitu"][i] for i in ix_plot]

# open matplotlib figure object
fig, ax = plt.subplots(figsize=(5, 6))

# plot data
ax.scatter(df["SMAP"], np.arange(1,21), zorder=93, label="SMAP validation 2018",
           color="#1f78b4")
ax.scatter(df["2016_SMAP"], np.arange(1,21), zorder=93, label="SMAP validation 2016",
           color="#a6cee3",
           marker="^")

ax.scatter(rmse_sim_loc, ix_plot, zorder=95, label="Field validation 2018",
           marker="s",
           color="#33a02c")
ax.scatter(rmse_sim_loc2016, ix_plot, zorder=95, label="Field validation 2016",
           marker="*",
           color="#b2df8a")

# set figure axes limits
ax.set_xlim(0, 0.25)
ax.set_ylim(0, 21)

# set y axis ticks
ax.set_yticks(np.arange(1,21))

# plot horizontal reference lines
for i in np.arange(1,21):
    ax.hlines(i, 0, 0.25,
              linestyles="dashed", 
              linewidths=0.5,
              zorder=2)

# invert y axis
ax.invert_yaxis()

# add legend
ax.legend(fancybox=False,
              framealpha=1,
              loc="upper center",
              ncol=2,
              bbox_to_anchor=(0.5, 1.14))

# set axes labels
ax.set_xlabel('RMSE [$m^3\ m^{-3}$]')
ax.set_ylabel("Location [-]")

# save figure to png and pdf
fig.savefig("TFN_SMAP_insitu_RMSE_2016.png",
            dpi=300,
            bbox_inches="tight")

fig.savefig("TFN_SMAP_insitu_RMSE_2016.pdf",
            dpi=300,
            bbox_inches="tight") 