#!/bin/sh

## This job file is for snellius super computer (https://www.surf.nl)

#SBATCH -J "<caseName>"
#SBATCH --partition=genoa
#SBATCH --time=120:00:00
#SBATCH --ntasks=<coresRequested>
#SBATCH --nodes=<nodesRequested>
#SBATCH --exclusive
#SBATCH --output JobStatistics_%j.log

module load EESSI/2023.06
module load OpenFOAM/v2312-foss-2023a
source /cvmfs/software.eessi.io/versions/2023.06/software/linux/x86_64/amd/zen2/software/OpenFOAM/v2312-foss-2023a/OpenFOAM-v2312/etc/bashrc

module list

rm -rf ./0

cp -r ./0.org ./0

blockMesh  > blockMesh.log 2>&1

topoSet    > topoSet.log 2>&1

decomposePar -force > decompose.log 2>&1

mpirun -n <coresRequested> pimpleFoam -parallel > solver.log 2>&1

reconstructPar  > reconstructPar.log 2>&1
