
rm(list=ls())								## clear workspace ##

# Set working directory


# Load packages
library("readxl")
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library("RVAideMemoire")
library("MuMIn")
library("sjPlot")
library("ggplot2")
library("vegan")
library("pals")
library("tidyverse")
library("PCAtools")
library("ggeffects")
library("ggfortify")
library("gridExtra")
library("ggvegan")

# function to compare GLMs ##### Function by Daan to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}

#### load data file ####
Data <- read_xlsx("Data/Large-scale monitoring data.xlsx", sheet = "Processed")

Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT"))

Data$Round <- as.factor(Data$Round)
levels(Data$Round) <- c("Round 1", "Round 2")

str(Data)

# Add functional groups
AG_Phloem_feeders <- c("Aphid_other","Brevicoryne_brassicae","mummy","Myzus_persicae")
AG_Chewers <- c("Autographa_gamma","Mamestra_brassicae","Miner","Phyllotreta_atra","Phyllotreta_undulata","Pieris_brassicae","Pieris_rapae", "Plutella_xylostella","Thrips")
BG_Predators <- c("Anthicidae","Carabid_beetle","Carabid_Rove_Larvae","Centipede","Ceratopogonidae_larva","Rove_beetle","Spider","Velvet_Mite")
BG_Detrivores <- c("Dung_beetle","Earthworm","Scarab_Larvae")
BG_Herbivores <- c("Click_beetle","Click_Beetle_Larvae","Cut_Worm")

Data %>% select(AG_Phloem_feeders) %>% rowSums() -> Data$AG_Phloem_feeders
Data %>% select(AG_Chewers) %>% rowSums() -> Data$AG_Chewers
Data %>% select(BG_Predators) %>% rowSums() -> Data$BG_Predators
Data %>% select(BG_Detrivores) %>% rowSums() -> Data$BG_Detrivores
Data %>% select(BG_Herbivores) %>% rowSums() -> Data$BG_Herbivores

# Manually remove some groups
Data <- select(Data, -Ant, -Beetle_Pupa, -Cecidomyiidae_larva)
str(Data)
##

#### Subsets
Data_R1 <- Data[Data$Round == "Round 1",]
Data_R1 <- droplevels(Data_R1)

Data_R2 <- Data[Data$Round == "Round 2",]
Data_R2 <- droplevels(Data_R2)

Data_Strip <- Data[Data$Treatment == "Strip",]
Data_Strip <- droplevels(Data_Strip)

Data_Field10 <- Data[Data$Field == "10",]
Data_Field10 <- droplevels(Data_Field10)

# Color theme
col <- (c("Ref"= "#895E39",
          "Strip" = "#B6DA60",
          "Strip_VAR" = "#308188",
          "Strip_ADD" = "#19399F",
          "Strip_ROT" = "#9671bd"))



### PCA of AG and BG communities ####

str(Data_R1)

Data_PCA_R1 <- as.data.frame(Data_R1 %>% select(Total_Delia:Miner)) # Or should it start at Carabid_beetle
rownames(Data_PCA_R1) <- Data_R1$ID
filter <- colSums(Data_PCA_R1) >= 10
summary(filter)
Data_PCA_R1 <- Data_PCA_R1[,filter]


Data_PCA_R1_transformed <- decostand(Data_PCA_R1, method = "hellinger")
PCA_R1 <- prcomp(Data_PCA_R1_transformed)
summary(PCA_R1)
loadings(PCA_R1)
p<- autoplot(PCA_R1, data = Data_R1,
             x = 1, y = 2,
             colour = "Treatment",
             #size = "Total_Delia",
             size = 2.5,
             loadings = TRUE,
             loadings.label = TRUE,
             loadings.label.size = 2.5,
             loadings.label.colour='red',
             loadings.colour = 'red')+
  scale_color_manual(values = col)+
  theme_bw()
p

# ggsave("Figures/PCA_R1_hellinger_onesize.pdf",
#        width = 7,
#        height = 6)

PCA_R1 <- pca(Data_PCA_R1_transformed, 
              transposed = T)
summary(PCA_R1)
screeplot(PCA_R1)
plotloadings(PCA_R1, labSize = 3, rangeRetain = 0.1)


PCA_R1 <- princomp(log10(Data_PCA_R1+1))
autoplot(PCA_R1, data = Data_R1,
         x = 1, y = 2,
         colour = "Treatment",
         size = "Total_Delia",
         loadings = TRUE,
         loadings.label = TRUE)+
  scale_color_manual(values = col)+
  labs(title = "Round 1 Log10")+
  theme_bw()

#Round 2


Data_PCA_R2 <- as.data.frame(Data_R2 %>% select(Total_Delia:Miner))
rownames(Data_PCA_R2) <- Data_R2$ID
filter <- colSums(Data_PCA_R2) >= 10
summary(filter)
Data_PCA_R2 <- Data_PCA_R2[,filter]

Data_PCA_R2_transformed <- decostand(Data_PCA_R2, method = "hellinger")
PCA_R2 <- princomp(Data_PCA_R2_transformed)
summary(PCA_R2)

p<- autoplot(PCA_R2, data = Data_R2,
             x = 1, y = 2,
             colour = "Treatment",
             #size = "Total_Delia",
             size = 2.5,
             loadings = TRUE,
             loadings.label = TRUE,
             loadings.label.size = 2.5,
             loadings.label.colour='red',
             loadings.colour = 'red')+
  scale_color_manual(values = col)+
  theme_bw()
p

# ggsave("Figures/PCA_R2_hellinger_onesize.pdf",
#        width = 7,
#        height = 6)

PCA_R2 <- pca(Data_PCA_R2_transformed, 
              transposed = T)
summary(PCA_R2)
screeplot(PCA_R2)
plotloadings(PCA_R2, labSize = 3, rangeRetain = 0.05)

PCA_R2 <- princomp(log10(Data_PCA_R2+1))
autoplot(PCA_R2, data = Data_R2,
         x = 1, y = 2,
         colour = "Treatment",
         size = "Total_Delia",
         loadings = TRUE,
         loadings.label = TRUE)+
  scale_color_manual(values = col)+
  labs(title = "Round 1 Log10")+
  theme_bw()




## RDA analysis
#Round 1
str(Data_R1)
Data_R1 <- as.data.frame(Data_R1)
rownames(Data_R1) <- Data_R1$Plant_ID

Data_PCA_R1 <- as.data.frame(Data_R1 %>% select(Carabid_beetle:Miner))
rownames(Data_PCA_R1) <- Data_R1$Plant_ID
filter <- colSums(Data_PCA_R1) >= 10
Data_PCA_R1 <- Data_PCA_R1[,filter]
Data_PCA_R1_transformed <- decostand(Data_PCA_R1, method = "hellinger")

RDA_R1 <- rda(Data_PCA_R1_transformed ~ Data_R1$Total_Delia, na.rm = F)
summary(RDA_R1)
plot(RDA_R1)
anova(RDA_R1, by="term", permutations=999)

p<- autoplot(RDA_R1, data = Data_R1)+
  geom_point(x = ~RDA1, y = ~PC1, colour = Data_R1$Treatment)+
  theme_bw()
p



ii=summary(RDA_R1)  #View analysis results
sp=as.data.frame(ii$species[,1:2])*2#Depending on the drawing result, the drawing data can be enlarged or reduced to a certain extent, as follows
st=as.data.frame(ii$sites[,1:2])
yz=as.data.frame(t(ii$biplot[,1:2]))
rownames(yz)=c("Total_Delia")
grp=data.frame(Data_R1$Treatment, Data_R1$Total_Delia)
colnames(grp)=c("Treatment", "Total_Delia")
length(st$RDA1)
length(grp$Treatment)

ggplot() +
  #geom_text_repel(data = st,aes(RDA1,PC1,label=row.names(st)),size=2)+#Show a Square
  geom_point(data = st,aes(RDA1,PC1, col=Data_R1$Treatment
                           #,size = Data_R1$Total_Delia
                           )
             ,size = 2.5
             )+
  scale_color_manual(values = col)+
  geom_segment(data = sp,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text(data = sp,aes(RDA1,PC1,label=row.names(sp)),colour = "red")+
  geom_segment(data = yz,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "blue")+
  geom_text_repel(data = yz,aes(RDA1,PC1,label=row.names(yz)),colour = "blue")+
  labs(x=paste("RDA 1 (", format(100 *ii$cont[[1]][2,1], digits=4), "%)", sep=""),
       y=paste("PC 1 (", format(100 *ii$cont[[1]][2,2], digits=4), "%)", sep=""))+
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()

# ggsave("Figures/RDA_R1_hellinger_onesize.pdf",
#        width = 10,
#        height = 8)


#Round 2
str(Data_R2)
Data_R2 <- as.data.frame(Data_R2)
rownames(Data_R2) <- Data_R2$Plant_ID

Data_PCA_R2 <- as.data.frame(Data_R2 %>% select(Carabid_beetle:Miner))
rownames(Data_PCA_R2) <- Data_R2$Plant_ID
filter <- colSums(Data_PCA_R2) >= 10
Data_PCA_R2 <- Data_PCA_R2[,filter]
Data_PCA_R2_transformed <- decostand(Data_PCA_R2, method = "hellinger")

RDA_R2 <- rda(Data_PCA_R2_transformed ~ Data_R2$Total_Delia, na.rm = F)
summary(RDA_R2)
plot(RDA_R2)
anova(RDA_R2, by="term", permutations=999)

p<- autoplot(RDA_R2, data = Data_R2)+
  geom_point(x = ~RDA1, y = ~PC1, colour = Data_R2$Treatment)+
  theme_bw()
p



ii=summary(RDA_R2)  #View analysis results
sp=as.data.frame(ii$species[,1:2])*2#Depending on the drawing result, the drawing data can be enlarged or reduced to a certain extent, as follows
st=as.data.frame(ii$sites[,1:2])
yz=as.data.frame(t(ii$biplot[,1:2]))
rownames(yz)=c("Total_Delia")
grp=data.frame(Data_R2$Treatment, Data_R2$Total_Delia)
colnames(grp)=c("Treatment", "Total_Delia")
length(st$RDA1)
length(grp$Treatment)

ggplot() +
  #geom_text_repel(data = st,aes(RDA1,PC1,label=row.names(st)),size=2)+#Show a Square
  geom_point(data = st,aes(RDA1,PC1, col=Data_R2$Treatment
                           #, size = Data_R2$Total_Delia
                           )
             , size = 2.5
             )+
  scale_color_manual(values = col)+
  geom_segment(data = sp,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text(data = sp,aes(RDA1,PC1,label=row.names(sp)),colour = "red")+
  geom_segment(data = yz,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "blue")+
  geom_text_repel(data = yz,aes(RDA1,PC1,label=row.names(yz)),colour = "blue")+
  labs(x=paste("RDA 1 (", format(100 *ii$cont[[1]][2,1], digits=4), "%)", sep=""),
       y=paste("PC 1 (", format(100 *ii$cont[[1]][2,2], digits=4), "%)", sep=""))+
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()

# ggsave("Figures/RDA_R2_hellinger_onesize.pdf",
#        width = 10,
#        height = 8)

