
rm(list=ls())								## clear workspace ##

# Set working directory



# Load packages
library(readxl)
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library(RVAideMemoire)
library(MuMIn)
library("sjPlot")
library(ggplot2)
library(vegan)
library(pals)
library(tidyverse)
library(PCAtools)
library(ggeffects)
library(ggfortify)
library(gridExtra)
#### load data file ####
Data <- read_xlsx("Data/Pupa_data.xlsx", sheet = "Processed")

Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT"))

Data$Round <- as.factor(Data$Round)
levels(Data$Round) <- c("Round 1", "Round 2")

str(Data)

### Stacked bar Delia's
Stack_Data <- as.data.frame(Data %>% select(Treatment, Round, `Delia radicum`:`Trybliographa rapae`))
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)
Stack_Data$Species <- factor(Stack_Data$Species, 
                             levels = c("Trybliographa rapae",
                                        "Aleochara bilineata",
                                        "Aleochara bipustulata",
                                        "Delia radicum"))

color <- viridis(6)

p <- ggplot(Stack_Data, aes(fill=Species, y=count, x=Round)) + 
  geom_bar(position="stack", stat = "summary", fun = "sum", colour="black")+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Sum emerged")+
  theme_classic()
p



ggsave("Figures/pupa_parasitism.pdf", p,
       width = 6,
       height = 6)
