
rm(list=ls())								## clear workspace ##

# Set working directory

# Load packages
library(readxl)
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library(RVAideMemoire)
library(MuMIn)
library("sjPlot")
library(ggplot2)
library(vegan)
library(pals)
library(tidyverse)

# function to compare GLMs ####
# Function by Daan to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}


#### load data file ####
Data <- read_xlsx("Data/Pitfall data.xlsx", sheet = "Pitfalls combined")

Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT",
                                    "Pixel"))

Data$Round <- as.factor(Data$Round)
levels(Data$Round) <- c("Round 1", "Round 2")



str(Data)

#### Subsets
Data_R1 <- Data[Data$Round == "Round 1",]
Data_R1 <- droplevels(Data_R1)

Data_R2 <- Data[Data$Round == "Round 2",]
Data_R2 <- droplevels(Data_R2)

## Diet data
Data_Diet <- read_xlsx("Data/Pitfall data.xlsx", sheet = "Diet")
Data_Diet <- Data_Diet[,1:5]

Predators <- Data_Diet[Data_Diet$Predator == "Yes",]$Species
Predators

Egg_predators <- Data_Diet[Data_Diet$Egg_predator == "Maybe"| Data_Diet$Egg_predator == "Yes", ]$Species
Egg_predators


# Add Total_Predators column
Data %>% select(Predators) %>% rowSums() -> Data$Total_Predators

# Add Egg_Predators column
Data %>% select(Egg_predators) %>% rowSums() -> Data$Egg_predators

# Filter Data, only show species of interest (Egg)predators
Interesting_filter <- c("Field", "Treatment", "Round", Predators, Egg_predators)
Data_Pred <- Data[, colnames(Data) %in% Interesting_filter]
Data_R1_Pred <- Data_R1[, colnames(Data_R1) %in% Interesting_filter]
Data_R2_Pred <- Data_R2[, colnames(Data_R2) %in% Interesting_filter]



# Color theme
col <- (c("Ref"= "#895E39",
          "Strip" = "#B6DA60",
          "Strip_VAR" = "#308188",
          "Strip_ADD" = "#19399F",
          "Strip_ROT" = "#9671bd",
          "Pixel" = "#B22E5D"))


## Stacked bars of pitfalls

# Filter data with >5 counts in one of the rounds
Data_Stack_R1 <- as.data.frame(Data_R1 %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
Data_Stack_R2 <- as.data.frame(Data_R2 %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
filter1 <- colSums(Data_Stack_R1 %>% select('Rove beetle':'Ground beetle')) >= 5
summary(filter1)
filter2 <- colSums(Data_Stack_R2 %>% select('Rove beetle':'Ground beetle')) >= 5
summary(filter2)
filter <- names(which(c(filter1, filter2), arr.ind = FALSE, useNames = TRUE))
filter <- c("Treatment", "Round", filter)

Stack_Data <- as.data.frame(Data %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
Stack_Data <- Stack_Data[, colnames(Stack_Data)%in% filter]
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)

color <- tol.rainbow(23)
p<- ggplot(Stack_Data, aes(fill=Species, y=count, x=Treatment)) + 
  geom_bar(position="stack", stat = "summary", fun = "mean", colour="black", size=0.15)+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Average count")+
  theme_classic()+
  theme(axis.text.x = element_text(angle = 90, vjust = 1, hjust=1))+
  facet_wrap(~Round)
p

# ggsave("Figures/Stacked_pitfall_total.pdf",p,
#        width = 12,
#        height = 6)

# Filter data with >5 counts in one of the rounds
Data_Stack_R1 <- as.data.frame(Data_R1_Pred %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
Data_Stack_R2 <- as.data.frame(Data_R2_Pred %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
filter1 <- colSums(Data_Stack_R1 %>% select('Rove beetle':'Ground beetle')) >= 5
summary(filter1)
filter2 <- colSums(Data_Stack_R2 %>% select('Rove beetle':'Ground beetle')) >= 5
summary(filter2)
filter <- names(which(c(filter1, filter2), arr.ind = FALSE, useNames = TRUE))
filter <- c("Treatment", "Round", filter)

Stack_Data <- as.data.frame(Data_Pred %>% select(Treatment, Round, 'Rove beetle':'Ground beetle'))
Stack_Data <- Stack_Data[, colnames(Stack_Data)%in% filter]
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)

color <- tol.rainbow(7)
p<- ggplot(Stack_Data, aes(fill=Species, y=count, x=Treatment)) + 
  geom_bar(position="stack", stat = "summary", fun = "mean", colour="black", size=0.15)+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Average count")+
  theme_classic()+
  theme(axis.text.x = element_text(angle = 90, vjust = 1, hjust=1))+
  facet_wrap(~Round)
p

# ggsave("Figures/Stacked_pitfall_groups_of_interest.pdf",p,
#        width = 10,
#        height = 6)  


## Ground beetle stacked bar
Data_Stack_R1 <- as.data.frame(Data_R1_Pred %>% select(Treatment, Round, 'Pterostichus_melanarius':'Agonum_muelleri'))
Data_Stack_R2 <- as.data.frame(Data_R2_Pred %>% select(Treatment, Round, 'Pterostichus_melanarius':'Agonum_muelleri'))
filter1 <- colSums(Data_Stack_R1 %>% select('Pterostichus_melanarius':'Agonum_muelleri')) >= 5
summary(filter1)
filter2 <- colSums(Data_Stack_R2 %>% select('Pterostichus_melanarius':'Agonum_muelleri')) >= 5
summary(filter2)
filter <- names(which(c(filter1, filter2), arr.ind = FALSE, useNames = TRUE))
filter <- c("Treatment", "Round", filter)

Stack_Data <- as.data.frame(Data %>% select(Treatment, Round, 'Pterostichus_melanarius':'Agonum_muelleri'))
Stack_Data <- Stack_Data[, colnames(Stack_Data)%in% filter]
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)

color <- cividis(10)
p<- ggplot(Stack_Data, aes(fill=Species, y=count, x=Treatment)) + 
  geom_bar(position="stack", stat = "summary", fun = "mean", colour="black", size=0.15)+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Average count")+
  theme_classic()+
  theme(axis.text.x = element_text(angle = 90, vjust = 1, hjust=1))+
  facet_wrap(~Round)
p


# ggsave("Figures/Stacked_pitfall_groundbeetle.pdf",p,
#        width = 10,
#        height = 6)  

## Combined stacked bar
Data_Stack_R1 <- as.data.frame(Data_R1_Pred %>% select(Treatment, Round, 'Rove beetle', 'GB/RB larvae':'Agonum_muelleri'))
Data_Stack_R2 <- as.data.frame(Data_R2_Pred %>% select(Treatment, Round, 'Rove beetle', 'GB/RB larvae':'Agonum_muelleri'))
filter1 <- colSums(Data_Stack_R1 %>% select('Rove beetle':'Agonum_muelleri')) >= 5
summary(filter1)
filter2 <- colSums(Data_Stack_R2 %>% select('Rove beetle':'Agonum_muelleri')) >= 5
summary(filter2)
filter <- names(which(c(filter1, filter2), arr.ind = FALSE, useNames = TRUE))
filter <- c("Treatment", "Round", filter)

Stack_Data <- as.data.frame(Data_Pred %>% select(Treatment, Round, 'Rove beetle':'Agonum_muelleri'))
Stack_Data <- Stack_Data[, colnames(Stack_Data)%in% filter]
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)

Stack_Data$Species <- factor(Stack_Data$Species,
                             levels = c("GB/RB larvae", 
                                        "Rove beetle", "Amara_aenea", "Broscus_cephalotes",
                                        "Calathus_eratus","Calathus_melanocephalus","Harpalus_affinis", 
                                        "Harpalus_flavescens","Harpalus_rufipes","Pterostichus_melanarius"           
                             ))

color <-  ocean.thermal(11)
  
p<- ggplot(Stack_Data, aes(fill=Species, y=count, x=Treatment)) + 
  geom_bar(position="stack", stat = "summary", fun = "mean", colour="black", size=0.15)+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Average count")+
  theme_bw()+
  theme(axis.text.x = element_text(angle = 90, vjust = 1, hjust=1))+
  facet_wrap(~Round)
p


# ggsave("Figures/Stacked_pitfall_combined.pdf",p,
#        width = 10,
#        height = 6) 

  
#### Analysis ###
## Total predators ##

summary(Data$Total_Predators)
p1 <- ggplot(Data, aes(x=Treatment, y=Total_Predators, fill=Treatment)) + 
  geom_boxplot(outlier.shape = NA)+
  geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 50), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p1

# ggsave(file = "Figures/pitfall_Predators.pdf", p1,
#        width = 10,
#        height = 6)



## Effect of treatment on Total Predators
M4 <- glmer(Total_Predators ~ Treatment * Round +(1|Field), family ="poisson", data = Data)
testDispersion(M4, alternative = "greater") # this model is overdispersed :-(
RVAideMemoire::overdisp.glmer(M4) # this model is overdispersed :-(

# negative binomial
M4 <- glmer.nb(Total_Predators ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(Total_Predators ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(Total_Predators ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(Total_Predators ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(Total_Predators ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T)
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")



## Egg predators ##

summary(Data$Egg_predators)
p4 <- ggplot(Data, aes(x=Treatment, y=Egg_predators, fill=Treatment)) + 
  geom_boxplot(outlier.shape = NA)+
  geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 30), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p4

# ggsave(file = "Figures/pitfall_eggpredators.pdf", p4,
#        width = 10,
#        height = 6)


## Effect of treatment on Egg predators
M4 <- glmer(Egg_predators ~ Treatment * Round +(1|Field), family ="poisson", data = Data)
testDispersion(M4, alternative = "greater") # this model is overdispersed :-(
RVAideMemoire::overdisp.glmer(M4) # this model is overdispersed :-(

# negative binomial
M4 <- glmer.nb(Egg_predators ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(Egg_predators ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(Egg_predators ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(Egg_predators ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(Egg_predators ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T)
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")


## Ground beetle ##

summary(Data$`Ground beetle`)
p2 <- ggplot(Data, aes(x=Treatment, y=`Ground beetle`, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 40), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p2

# ggsave(file = "Figures/pitfall_groundbeetles.pdf", p2,
#        width = 10,
#        height = 6)


## Effect of treatment on Ground beetles
M4 <- glmer(`Ground beetle` ~ Treatment * Round +(1|Field), family ="poisson", data = Data)
testDispersion(M4, alternative = "greater") # this model is overdispersed :-(
RVAideMemoire::overdisp.glmer(M4) # this model is overdispersed :-(

# negative binomial
M4 <- glmer.nb(`Ground beetle` ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(`Ground beetle` ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(`Ground beetle` ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(`Ground beetle` ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(`Ground beetle` ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T)
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")


## Rove beetles ##

summary(Data$`Rove beetle`)
p3 <- ggplot(Data, aes(x=Treatment, y=`Rove beetle`, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free")+
  theme_bw()+
  scale_y_continuous(limits = c(0, NA), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p3

# ggsave(file = "Figures/pitfall_rovebeetles.pdf", p3,
#        width = 10,
#        height = 6)

## Effect of treatment on Rove beetles
M4 <- glmer(`Rove beetle` ~ Treatment * Round +(1|Field), family ="poisson", data = Data)
testDispersion(M4, alternative = "greater") # this model is overdispersed :-(
RVAideMemoire::overdisp.glmer(M4) # this model is overdispersed :-(

# negative binomial
M4 <- glmer.nb(`Rove beetle` ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(`Rove beetle` ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(`Rove beetle` ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(`Rove beetle` ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(`Rove beetle` ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T)
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")


