
rm(list=ls())								## clear workspace ##

# Set working directory

# Load packages
library(readxl)
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library(RVAideMemoire)
library(MuMIn)
library("sjPlot")
library(ggplot2)
library(vegan)
library(pals)
library(tidyverse)
library(PCAtools)
library(ggeffects)
library(ggfortify)
library(gridExtra)

# function to compare GLMs ####
# Function by Daan to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}


#### load data file ####
Data <- read_xlsx("Data/Oviposition data.xlsx", sheet = "Oviposition_AGcomm")


Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT",
                                    "Pixel"))

Data$Round <- as.factor(Data$Round)
Data$Cabbage_cultivar <- as.factor(Data$Cabbage_cultivar)
levels(Data$Round) <- c("Round 1", "Round 2")


str(Data)

# Subset with Xmas drumhead
Data_xmas <- Data[Data$Treatment == "Strip_VAR",]
Data_xmas <- droplevels(Data_xmas)
str(Data_xmas)

# Remove Xmas drumhead for further analysis
Data <- Data[Data$Cabbage_cultivar == "Rivera",]
Data <- droplevels(Data)
str(Data)

#### Subsets
Data_R1 <- Data[Data$Round == "Round 1",]
Data_R1 <- droplevels(Data_R1)

Data_R2 <- Data[Data$Round == "Round 2",]
Data_R2 <- droplevels(Data_R2)

Data_Strip <- Data[Data$Treatment == "Strip",]
Data_Strip <- droplevels(Data_Strip)

# Color theme
col <- (c("Ref"= "#895E39",
          "Strip" = "#B6DA60",
          "Strip_VAR" = "#308188",
          "Strip_ADD" = "#19399F",
          "Strip_ROT" = "#9671bd",
          "Pixel" = "#B22E5D"))

## Leaves (NOT USED IN PAPER)
summary(Data$Leaves)

## Plot Leaves
p1 <- ggplot(Data, aes(x=Treatment, y=Leaves, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free")+
  theme_bw()+
  scale_y_continuous(oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))+
  expand_limits(y = 0)
p1
 
# ggsave(file = "Figures/Leaves.pdf", p1,
#        width = 10,
#        height = 6)


Mod <- glmer(Leaves ~ Treatment +(1|Field), data = Data_R1, family = poisson())
testDispersion(Mod, alternative = "greater") # this model is not overdispersed
Mod <- glmer(Leaves ~ Treatment +(1|Field), data = Data_R2, family = poisson())
testDispersion(Mod, alternative = "greater") # this model is not overdispersed

## Round 1

M1 <- glmer(Leaves ~ Treatment +(1|Field),family = poisson(), data = Data_R1)
M0 <- glmer(Leaves ~ 1 +(1|Field),family = poisson(), data = Data_R1)

cbind(Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M1)
plot(sim_fmnb)
tab_model(M1)

lrtest(M1, M0) 
summary(M1)

# posthoc
posthoc <- emmeans(M1, pairwise ~ Treatment, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

## Round 2

M1 <- glmer(Leaves ~ Treatment +(1|Field),family = poisson(), data = Data_R2)
M0 <- glmer(Leaves ~ 1 +(1|Field),family = poisson(), data = Data_R2)

cbind(Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M1)
plot(sim_fmnb)
tab_model(M1)

lrtest(M1, M0) 
summary(M1)

# posthoc
posthoc <- emmeans(M1, pairwise ~ Treatment, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

## Delia eggs and Leaves

MR1 <- glmer.nb(Eggs ~ Leaves +  (1|Field), data = Data_R1,
                na.action = "na.fail")
summary(MR1)
drop1(MR1, test = "Chisq")

MR2 <- glmer.nb(Eggs ~ Leaves + (1|Field), data = Data_R2,
                na.action = "na.fail")
summary(MR2)
drop1(MR2, test = "Chisq")

MR1_predict <- ggpredict(MR1)
p<- plot(MR1_predict, add.data = TRUE,show.title = F)
p

MR2_predict <- ggpredict(MR2)
p1<-plot(MR2_predict, add.data = TRUE,show.title = F)
p1

grid.arrange(p$Leaves, p1$Leaves,
             nrow = 1)
g<- arrangeGrob(p$Leaves, p1$Leaves,
                ncol = 1)

ggsave(file = "Figures/ggpredict_leaves_R1_R2.pdf", g,
       height = 8,
       width = 4)


## Radius
summary(Data$Radius)

summary(Data_R1$Radius)
#Data_R1 <- Data_R1[Data_R1$Radius < 90,] # Exclude outlier cc1190 <- this doesnt change outcome of the analysis
summary(Data_R1$Radius)
qqnorm(Data_R1$Radius)
shapiro.test(Data_R1$Radius)
descdist(Data_R1$Radius, boot = 1000)


#Round 1 gamma dist

summary(Data_R2$Radius)
qqnorm(Data_R2$Radius)
shapiro.test(Data_R2$Radius)
descdist(Data_R2$Radius, boot = 1000)
# Round 2 normal dist

p1 <- ggplot(Data, aes(x=Treatment, y=Radius, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free")+
  theme_bw()+
  scale_y_continuous(oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))+
  expand_limits(y = 0)
p1

# ggsave(file = "Figures/Radius.pdf", p1,
#        width = 10,
#        height = 6)



## Round 1

M1 <- glmer(Radius ~ Treatment +(1|Field),family = Gamma, data = Data_R1)
M0 <- glmer(Radius ~ 1 +(1|Field),family = Gamma, data = Data_R1)

M1 <- lmer(Radius ~ Treatment +(1|Field), data = Data_R1)
M0 <- lmer(Radius ~ 1 +(1|Field), data = Data_R1)
# Normal distribution meets model assumptions and better AIC, use this one

cbind(Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M1)
plot(sim_fmnb)
tab_model(M1)


lrtest(M1, M0) 
summary(M1)

# posthoc
posthoc <- emmeans(M1, pairwise ~ Treatment, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

## Round 2

M1 <- lmer(Radius ~ Treatment +(1|Field), data = Data_R2)
M0 <- lmer(Radius ~ 1 +(1|Field), data = Data_R2)

cbind(Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M1)
plot(sim_fmnb)
tab_model(M1)

lrtest(M1, M0) 
summary(M1)

# posthoc
posthoc <- emmeans(M1, pairwise ~ Treatment, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

## Delia eggs and Radius

MR1 <- glmer.nb(Eggs ~ Radius +  (1|Field), data = Data_R1,
                na.action = "na.fail")
summary(MR1)
sim_fmnb <- simulateResiduals(MR1)
plot(sim_fmnb)
tab_model(MR1)

drop1(MR1, test = "Chisq")

MR2 <- glmer.nb(Eggs ~ Radius + (1|Field), data = Data_R2,
                na.action = "na.fail")
summary(MR2)
sim_fmnb <- simulateResiduals(MR2)
plot(sim_fmnb)
tab_model(MR2)
drop1(MR2, test = "Chisq")

MR1_predict <- ggpredict(MR1)
p<- plot(MR1_predict, add.data = TRUE,show.title = F)
p

MR2_predict <- ggpredict(MR2)
p1<-plot(MR2_predict, add.data = TRUE,show.title = F)
p1

grid.arrange(p$Radius, p1$Radius,
             nrow = 1)
g<- arrangeGrob(p$Radius, p1$Radius,
                ncol = 1)

# ggsave(file = "Figures/ggpredict_Radius_R1_R2.pdf", g,
#        height = 8,
#        width = 4)




