
rm(list=ls())								## clear workspace ##

# Set working directory

# Load packages
library(readxl)
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library(RVAideMemoire)
library(MuMIn)
library("sjPlot")
library(ggplot2)
library(ggeffects)
library(ggfortify)
library(gridExtra)
library(pals)

# function to compare GLMs ####
# Function by Daan to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}


#### load data file ####
Data <- read_xlsx("Data/Oviposition data.xlsx", sheet = "Oviposition")

Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT",
                                    "Pixel"))

Data$Round <- as.factor(Data$Round)
Data$Cabbage_cultivar <- as.factor(Data$Cabbage_cultivar)


str(Data)

# Subset with Xmas drumhead
Data_xmas <- Data[Data$Treatment == "Strip_VAR",]
Data_xmas <- droplevels(Data_xmas)
str(Data_xmas)

# Remove Xmas drumhead for further analysis
Data <- Data[Data$Cabbage_cultivar == "Rivera",]
Data <- droplevels(Data)
str(Data)

#### Subsets
Data_R1 <- Data[Data$Round == "1",]
Data_R1 <- droplevels(Data_R1)

Data_R2 <- Data[Data$Round == "2",]
Data_R2 <- droplevels(Data_R2)

Data_Field10 <- Data[Data$Field == "10",]
Data_Field10 <- droplevels(Data_Field10)
str(Data_Field10)

Data_Strip <- Data[Data$Treatment == "Strip",]
Data_Strip <- droplevels(Data_Strip)

# Color theme
col <- (c("Ref"= "#895E39",
          "Strip" = "#B6DA60",
          "Strip_VAR" = "#308188",
          "Strip_ADD" = "#19399F",
          "Strip_ROT" = "#9671bd",
          "Pixel" = "#B22E5D"))

#### Data exploration

boxplot(Data_Field10$Eggs ~ Data_Field10$Treatment*Data_Field10$Round)

boxplot(Data$Eggs ~ Data$Field)

boxplot(Data_Strip$Eggs ~ Data_Strip$Field*Data_Strip$Round)

boxplot(Data$Eggs ~ Data$Treatment*Data$Round)

#### Analysis ##

## Field effect
    # The field effect can only statistically be studied within the strip treatment, 
    # because other treatments are not repeated in all fields.
summary(Data_Strip$Eggs)
p1 <- ggplot(Data_Strip, aes(x=Field, y=Eggs, fill=Field)) + 
  geom_boxplot(outlier.shape = NA)+
  geom_jitter(width = 0.1, alpha = 0.4)+  
  scale_fill_manual(values = rev(ocean.gray(6)[2:5]))+
  facet_wrap(~Round)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 75), oob = scales::squish)
p1

# ggsave(file = "Figures/Eggs_StripTreatment.pdf", p1,
#        width = 10,
#        height = 6)

Field_mod <- glm(Eggs ~ Field, data = Data_Strip, family = poisson())
testDispersion(Field_mod, alternative = "greater") # this model is overdispersed :-(

M4 <- glm.nb(Eggs ~ Field * Round, data = Data_Strip)
M3 <- glm.nb(Eggs ~ Field + Round, data = Data_Strip)
M2 <- glm.nb(Eggs ~ Field, data = Data_Strip)
M1 <- glm.nb(Eggs ~ Round, data = Data_Strip)
M0 <- glm.nb(Eggs ~ 1, data = Data_Strip)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))

#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)


lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 

# posthoc
posthoc <- emmeans(M4, pairwise ~ Field|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", adjust = "fdr")

plot(posthoc)

    # Field effect is not significant within Strip treatment.
    # But there is an interaction between field and round.. 
    # in the first round, Field 3 received more eggs than 1 and 10.

## Delia mono vs. strip
    # The most accurate comparison of strip vs. monoculture can be made by only comparing within field 10.

summary(Data_Field10$Eggs)
p1 <- ggplot(Data_Field10, aes(x=Treatment, y=Eggs, fill=Treatment)) + 
  geom_boxplot(outlier.shape = NA)+
  geom_jitter(width = 0.1, alpha = 0.4)+
  scale_fill_manual(values = col[1:2])+
  facet_wrap(~Round)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 75), oob = scales::squish)
p1

# ggsave(file = "Figures/Eggs_Field10.pdf", p1,
#        width = 10,
#        height = 6)

Mod <- glm(Eggs ~ Treatment*Round, data = Data_Field10, family = poisson())
testDispersion(Mod, alternative = "greater") # this model is overdispersed :-(
# Overdispersed -> switch to nb
 
M4 <- glm.nb(Eggs ~ Treatment * Round, data = Data_Field10)
M3 <- glm.nb(Eggs ~ Treatment + Round, data = Data_Field10)
M2 <- glm.nb(Eggs ~ Treatment, data = Data_Field10)
M1 <- glm.nb(Eggs ~ Round, data = Data_Field10)
M0 <- glm.nb(Eggs ~ 1, data = Data_Field10)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)


lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", adjust = "fdr")

plot(posthoc)

    # In field 10, there is no significant difference between monoculture and Strip
    # In round 1, a slight trend (p=0.0996) for more eggs in strip


## Xmas drumhead effect (NOT USED IN PAPER)
M4 <- glmer.nb(Eggs ~ Cabbage_cultivar * Round +(1|Field), data = Data_xmas)
M3 <- glmer.nb(Eggs ~ Cabbage_cultivar + Round +(1|Field), data = Data_xmas)
M2 <- glmer.nb(Eggs ~ Cabbage_cultivar +(1|Field), data = Data_xmas)
M1 <- glmer.nb(Eggs ~ Round +(1|Field), data = Data_xmas)
M0 <- glmer.nb(Eggs ~ 1 +(1|Field), data = Data_xmas)
str(Data_xmas)
cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
 # analyse full model

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 

summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Cabbage_cultivar|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

boxplot(Data_xmas$Eggs ~ Data_xmas$Cabbage_cultivar*Data_xmas$Round)

  # Xmas drumhead received less eggs than in round 2
  # Not sure if the comparison is fair, as the growth is so different between the two cultivars which may affect the method

## Treatment effect 

## Boxplot eggs treatment

Data$Round
levels(Data$Round) <- c("Round 1", "Round 2")

summary(Data$Eggs)
p1 <- ggplot(Data, aes(x=Treatment, y=Eggs, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free_y")+
  theme_bw()+
  scale_y_continuous(limits=c(0,100), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p1
# ggsave(file = "Figures/Eggs_Treatment_R1.pdf", p1,
#        width = 10,
#        height = 6)

p1 <- ggplot(Data, aes(x=Treatment, y=Eggs, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free_y")+
  theme_bw()+
  scale_y_continuous(limits=c(0,25), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p1
# ggsave(file = "Figures/Eggs_Treatment_R2.pdf", p1,
#        width = 10,
#        height = 6)


# check overdispersion
Mod <- glmer(Eggs ~ Treatment*Round+(1|Field), data = Data, family = poisson())
testDispersion(Mod, alternative = "greater") # this model is overdispersed :-(
overdisp.glmer(Mod)
# Overdispersed

M4 <- glmer.nb(Eggs ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(Eggs ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(Eggs ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(Eggs ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(Eggs ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model
#Check model assumptions and R2
sim_fmnb <- simulateResiduals(M4)
plot(sim_fmnb)
tab_model(M4)


lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)



# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)




## Field characteristics (NOT USED IN PAPER)
Mod <- glmer(Eggs ~ Strip + Cultivar + Nectar + Diversity +(1|Field), data = Data, family = poisson())
testDispersion(Mod, alternative = "greater") # this model is overdispersed :-(
overdisp.glmer(Mod)
# Overdispersed

MR1 <- glmer.nb(Eggs ~ Strip + Cultivar + Nectar + Diversity + Pixel + (1|Field), data = Data_R1)
MR2 <- glmer.nb(Eggs ~ Strip + Cultivar + Nectar + Diversity + Pixel + (1|Field), data = Data_R2)
MRC <- glmer.nb(Eggs ~ Strip + Cultivar + Nectar + Diversity + Pixel + (1|Field) + (1|Round), data = Data)

drop1(MR1, test = "Chisq")
drop1(MR2, test = "Chisq")
drop1(MRC, test = "Chisq")

summary(MR1)
summary(MR2)

p<- plot_models(MR1, MR2, MRC,
                m.labels = c("Round 1", "Round 2", "combined"),
                show.values = T, 
                show.p = T,
                legend.title = "Collection Round",
                axis.lim = c(0.1, 10),
                line.size = 1,
                dot.size = 4,
                colors = c("black", "gray40"))+
  theme_sjplot2()+
  geom_hline(yintercept = 1, alpha = .4)
p

# ggsave(file = "Figures/Eggs_Fieldchar.pdf", p,
#        width = 6,
#        height = 6)



  
  
  
  


