
rm(list=ls())								## clear workspace ##

# Set working directory

# Load packages
library(readxl)
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library(RVAideMemoire)
library(MuMIn)
library("sjPlot")
library(ggplot2)
library(vegan)
library(pals)
library(tidyverse)
library(PCAtools)
library(ggeffects)
#library(ggfortify)
library(gridExtra)
library(ggvegan)

# function to compare GLMs ####
# Function by Daan Mertens to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}


#### load data file ####
Data <- read_xlsx("Data/Oviposition data.xlsx", sheet = "Oviposition_AGcomm_herbivores")


Data$Field <- as.factor(Data$Field)
Data$Treatment <- factor(Data$Treatment,
                         levels = c("Ref",
                                    "Strip",
                                    "Strip_VAR",
                                    "Strip_ADD",
                                    "Strip_ROT",
                                    "Pixel"))

Data$Round <- as.factor(Data$Round)
Data$Cabbage_cultivar <- as.factor(Data$Cabbage_cultivar)
levels(Data$Round) <- c("Round 1", "Round 2")


str(Data)

# Subset with Xmas drumhead
Data_xmas <- Data[Data$Treatment == "Strip_VAR",]
Data_xmas <- droplevels(Data_xmas)
str(Data_xmas)

# Remove Xmas drumhead for further analysis
Data <- Data[Data$Cabbage_cultivar == "Rivera",]
Data <- droplevels(Data)
str(Data)

#### Subsets
Data_R1 <- Data[Data$Round == "Round 1",]
Data_R1 <- droplevels(Data_R1)

Data_R2 <- Data[Data$Round == "Round 2",]
Data_R2 <- droplevels(Data_R2)

Data_Strip <- Data[Data$Treatment == "Strip",]
Data_Strip <- droplevels(Data_Strip)

# Color theme
col <- (c("Ref"= "#895E39",
          "Strip" = "#B6DA60",
          "Strip_VAR" = "#308188",
          "Strip_ADD" = "#19399F",
          "Strip_ROT" = "#9671bd",
          "Pixel" = "#B22E5D"))

#### PCA of AG community ####
#library(ggfortify)

str(Data_R1)

Data_PCA_R1 <- as.data.frame(Data_R1 %>% select(Phu:Miner))
rownames(Data_PCA_R1) <- Data_R1$Plant_ID
filter <- colSums(Data_PCA_R1) >= 10
Data_PCA_R1 <- Data_PCA_R1[,filter]


Data_PCA_R1_transformed <- decostand(Data_PCA_R1, method = "hellinger")
PCA_R1 <- princomp(Data_PCA_R1_transformed)
summary(PCA_R1)

p<- autoplot(PCA_R1, data = Data_R1,
             x = 1, y = 2,
             colour = "Treatment",
             size = "Eggs",
             loadings = TRUE,
             loadings.label = TRUE,
             loadings.label.size = 2.5,
             loadings.label.colour='red',
             loadings.colour = 'red')+
  scale_color_manual(values = col)+
  theme_bw()
p


# ggsave("Figures/Eggs_PCA_R1_hellinger.pdf",
#        width = 7,
#        height = 6)


# Round 2

Data_PCA_R2 <- as.data.frame(Data_R2 %>% select(Phu:Miner))
rownames(Data_PCA_R2) <- Data_R2$Plant_ID
filter <- colSums(Data_PCA_R2) >= 10
Data_PCA_R2 <- Data_PCA_R2[,filter]

Data_PCA_R2_transformed <- decostand(Data_PCA_R2, method = "hellinger")
PCA_R2 <- princomp(Data_PCA_R2_transformed)
summary(PCA_R2)

fortify(PCA_R2)

p<- autoplot(PCA_R2, data = Data_R2,
             x = 1, y = 2,
             colour = "Treatment",
             size = "Eggs",
             loadings = TRUE,
             loadings.label = TRUE,
             loadings.label.size = 2.5,
             loadings.label.colour='red',
             loadings.colour = 'red')+
  scale_color_manual(values = col)+
  theme_bw()
p

# ggsave("Figures/Eggs_PCA_R2_hellinger.pdf",
#        width = 7,
#        height = 6)


# # RDA
# Round 1
str(Data_R1)
Data_R1 <- as.data.frame(Data_R1)
rownames(Data_R1) <- Data_R1$Plant_ID

Data_PCA_R1 <- as.data.frame(Data_R1 %>% select(Phu:Miner))
rownames(Data_PCA_R1) <- Data_R1$Plant_ID
filter <- colSums(Data_PCA_R1) >= 10
Data_PCA_R1 <- Data_PCA_R1[,filter]
Data_PCA_R1_transformed <- decostand(Data_PCA_R1, method = "hellinger")

RDA_R1 <- rda(Data_PCA_R1_transformed ~ Data_R1$Eggs, na.rm = F)
summary(RDA_R1)
plot(RDA_R1)
anova(RDA_R1, by="term", permutations=999)

p<- autoplot(RDA_R1, data = Data_R1)+
  geom_point(x = ~RDA1, y = ~PC1, colour = Data_R1$Treatment)+
  theme_bw()
p



ii=summary(RDA_R1)  #View analysis results
sp=as.data.frame(ii$species[,1:2])*2#Depending on the drawing result, the drawing data can be enlarged or reduced to a certain extent, as follows
st=as.data.frame(ii$sites[,1:2])
yz=as.data.frame(t(ii$biplot[,1:2]))
rownames(yz)=c("Eggs")
grp=data.frame(Data_R1$Treatment, Data_R1$Eggs)
colnames(grp)=c("Treatment", "Eggs")
length(st$RDA1)
length(grp$Treatment)

ggplot() +
  #geom_text_repel(data = st,aes(RDA1,PC1,label=row.names(st)),size=2)+#Show a Square
  geom_point(data = st,aes(RDA1,PC1, col=Data_R1$Treatment
                           #, size = Data_R1$Eggs
                           )
             ,size = 2.5
             )+
  scale_color_manual(values = col)+
  geom_segment(data = sp,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text(data = sp,aes(RDA1,PC1,label=row.names(sp)),colour = "red")+
  geom_segment(data = yz,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "blue")+
  geom_text_repel(data = yz,aes(RDA1,PC1,label=row.names(yz)),colour = "blue")+
  labs(x=paste("RDA 1 (", format(100 *ii$cont[[1]][2,1], digits=4), "%)", sep=""),
       y=paste("PC 1 (", format(100 *ii$cont[[1]][2,2], digits=4), "%)", sep=""))+
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()

# ggsave("Figures/Eggs_RDA_R1_onesize.pdf",
#        width = 10,
#        height = 8)



# R2
RDA_R2 <- rda(Data_PCA_R2_transformed ~ Data_R2$Eggs, na.rm=F)
summary(RDA_R2)
plot(RDA_R2)
anova(RDA_R2, by="term", permutations=999)

ii=summary(RDA_R2)  #View analysis results
sp=as.data.frame(ii$species[,1:2])*2#Depending on the drawing result, the drawing data can be enlarged or reduced to a certain extent, as follows
st=as.data.frame(ii$sites[,1:2])
yz=as.data.frame(t(ii$biplot[,1:2]))
rownames(yz)=c("Eggs")
grp=data.frame(Data_R2$Treatment, Data_R2$Eggs)
colnames(grp)=c("Treatment", "Eggs")
length(st$RDA1)
length(grp$Treatment)

ggplot() +
  #geom_text_repel(data = st,aes(RDA1,PC1,label=row.names(st)),size=2)+#Show a Square
  geom_point(data = st,aes(RDA1,PC1, col=Data_R2$Treatment
                           #, size = Data_R2$Eggs
                           )
             ,size = 2.5
             )+
  scale_color_manual(values = col)+
  geom_segment(data = sp,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "red")+
  geom_text(data = sp,aes(RDA1,PC1,label=row.names(sp)),colour = "red")+
  geom_segment(data = yz,aes(x = 0, y = 0, xend = RDA1, yend = PC1), 
               arrow = arrow(angle=22.5,length = unit(0.35,"cm"),
                             type = "closed"),linetype=1, size=0.6,colour = "blue")+
  geom_text_repel(data = yz,aes(RDA1,PC1,label=row.names(yz)),colour = "blue")+
  labs(x=paste("RDA 1 (", format(100 *ii$cont[[1]][2,1], digits=4), "%)", sep=""),
       y=paste("PC 1 (", format(100 *ii$cont[[1]][2,2], digits=4), "%)", sep=""))+
  geom_hline(yintercept=0,linetype=3,size=1) + 
  geom_vline(xintercept=0,linetype=3,size=1)+
  guides(shape=guide_legend(title=NULL,color="black"),
         fill=guide_legend(title=NULL))+
  theme_bw()

# ggsave("Figures/Eggs_RDA_R2_onesize.pdf",
#        width = 10,
#        height = 8)




## AG herbivore community stacked bar graphs
str(Data_R1)

# Filter data with >10 counts in one of the rounds
Data_Stack_R1 <- as.data.frame(Data_R1 %>% select(Treatment, Round, Phu:Miner))
Data_Stack_R2 <- as.data.frame(Data_R2 %>% select(Treatment, Round, Phu:Miner))
filter1 <- colSums(Data_Stack_R1 %>% select(Phu:Miner)) >= 10
filter2 <- colSums(Data_Stack_R2 %>% select(Phu:Miner)) >= 10
filter <- names(which(c(filter1, filter2), arr.ind = FALSE, useNames = TRUE))
filter <- c("Treatment", "Round", filter)

as.data.frame(colSums(Data %>% select(Phu:Miner)))


Stack_Data <- as.data.frame(Data %>% select(Treatment, Round, Phu:Miner))
Stack_Data <- Stack_Data[, colnames(Stack_Data)%in% filter]
Stack_Data <- gather(Stack_Data, key = Species, value = count, -Treatment, -Round)

# manually sorted by size
Stack_Data$Species <- factor(Stack_Data$Species,
                             levels = c("Mpn","Black","Aphid_other","Mummy","Mp","Bb",
                                        "Pr_pupae", "Mb_larvae", "Pb_larvae","Miner", 
                                        "Pha","Thrips_BnW","Ag_larvae","Thrips",
                                        "Plx_pupae_combined","Phu", "Pr_larvae","Plx_larvae"))


# 7 phloem feeders, 12 chewers, 3 eggs
color <- c(rev(brewer.brbg(18))[2:7],
           ocean.oxy(14)[1:12])

p<- ggplot(Stack_Data, aes(fill=Species, y=count, x=Treatment)) + 
  geom_bar(position="stack", stat = "summary", fun = "mean", colour="black", size=0.15)+
  scale_fill_manual(values = color)+
  scale_y_continuous(expand = expansion(mult = c(0, 0.05)))+
  labs(y = "Average count per plant")+
  theme_bw()+
  theme(axis.text.x = element_text(angle = 90, vjust = 1, hjust=1))+
  facet_wrap(~Round)
p




# ggsave("Figures/Eggs_Stacked_AGcomm.pdf",p,
#        width = 12,
#        height = 6)  

## AG herbivores by treatment
summary(Data$Total_Herbivores)
p1 <- ggplot(Data, aes(x=Treatment, y=Total_Herbivores, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free_y")+
  theme_bw()+
  scale_y_continuous(limits=c(0,NA), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p1

summary(Data$Total_Chewers)
p2 <- ggplot(Data, aes(x=Treatment, y=Total_Chewers, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free_y")+
  theme_bw()+
  scale_y_continuous(limits=c(0,NA), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p2

summary(Data$Total_Phloem_feeders)
p3 <- ggplot(Data, aes(x=Treatment, y=Total_Phloem_feeders, fill=Treatment)) + 
  geom_boxplot()+
  #geom_jitter(width = 0.1, alpha = 0.4, shape = 16)+
  scale_fill_manual(values = col)+
  facet_wrap(~Round, scales = "free_y")+
  theme_bw()+
  scale_y_continuous(limits=c(0,NA), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p3


library(egg)
g<-ggarrange(p1,p2,p3)
# ggsave(filename = "Figures/Eggs_AG_Comm_treatment.pdf", g,
#        width = 8,
#        height = 9)

## Effect of treatment on Phloem feeders
M4 <- glmer.nb(Total_Phloem_feeders ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(Total_Phloem_feeders ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(Total_Phloem_feeders ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(Total_Phloem_feeders ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(Total_Phloem_feeders ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)

## Effect of treatment on Chewers

M4 <- glmer.nb(Total_Chewers ~ Treatment * Round +(1|Field), data = Data)
M3 <- glmer.nb(Total_Chewers ~ Treatment + Round +(1|Field), data = Data)
M2 <- glmer.nb(Total_Chewers ~ Treatment +(1|Field), data = Data)
M1 <- glmer.nb(Total_Chewers ~ Round +(1|Field), data = Data)
M0 <- glmer.nb(Total_Chewers ~ 1 +(1|Field), data = Data)

cbind(Fit.stats(M4),Fit.stats(M3),Fit.stats(M2),Fit.stats(M1),Fit.stats(M0))
# analyse full model

lrtest(M4, M3) 
lrtest(M2, M0) 
lrtest(M1, M0) 


summary(M4)

# posthoc
posthoc <- emmeans(M4, pairwise ~ Treatment|Round, type = "response", adjustSigma =T, adjust = "fdr")
posthoc
cld(posthoc$emmeans, type = "response", Letters = "abcdefg", sort = T, adjust = "fdr")

plot(posthoc)
str(Data)



## Effects of AG herbivores on Delia egg numbers 

MR1 <- glmer.nb(Eggs ~ Total_Phloem_feeders + Total_Chewers + (1|Field), data = Data_R1,
                na.action = "na.fail")
MR2 <- glmer.nb(Eggs ~ Total_Phloem_feeders + Total_Chewers + (1|Field), data = Data_R2,
                na.action = "na.fail")
sim_fmnb <- simulateResiduals(MR1)
plot(sim_fmnb)
tab_model(MR1)

sim_fmnb <- simulateResiduals(MR2)
plot(sim_fmnb)
tab_model(MR2)

summary(MR1)
summary(MR2)

drop1(MR1, test = "Chisq")
drop1(MR2, test = "Chisq")

p<- plot_models(MR1, MR2,
                m.labels = c("Round 1", "Round 2"),
                show.values = T, 
                show.p = T,
                legend.title = "Collection Round",
                axis.lim = c(0.1, 10),
                line.size = 1,
                dot.size = 4,
                colors = c("black", "gray40"))+
  theme_sjplot2()+
  geom_hline(yintercept = 1, alpha = .4)
p

MR1_predict <- ggpredict(MR1)
p<- plot(MR1_predict, add.data = TRUE,show.title = F)

grid.arrange(p$Total_Phloem_feeders, p$Total_Chewers,
             nrow = 1)
g<- arrangeGrob(p$Total_Phloem_feeders, p$Total_Chewers,
                nrow = 1)
# ggsave(file = "Figures/Eggs_ggpredict_R1_func.pdf", g,
#        height = 4,
#        width = 8)


MR2_predict <- ggpredict(MR2)
p<- plot(MR2_predict, add.data = TRUE,show.title = F)

grid.arrange(p$Total_Phloem_feeders, p$Total_Chewers,
             nrow = 1)
g<- arrangeGrob(p$Total_Phloem_feeders, p$Total_Chewers,
                nrow = 1)
# ggsave(file = "Figures/Eggs_ggpredict_R2_func.pdf", g,
#        height = 4,
#        width = 8)

