
rm(list=ls())								## clear workspace ##

# Set working directory

# Load packages
library("readxl")
library("fitdistrplus")
library("lme4")
library("emmeans")
library("lmtest")
library("dplyr")
library("multcomp")
library("DHARMa")
library("RVAideMemoire")
library("MuMIn")
library("sjPlot")
library("ggplot2")
library("vegan")
library("pals")
library("tidyverse")
library("PCAtools")
library("ggeffects")
library("ggfortify")
library("gridExtra")

# function to compare GLMs ####
# Function by Daan Mertens to easily compare models for AIC, BIC and Log-likelyhood
Fit.stats <- function(Model){
  Model.Fit <- as.matrix(c(AIC(Model),BIC(Model),logLik(Model)))
  rownames(Model.Fit) <- c("AIC","BIC","LogLik")
  colnames(Model.Fit) <- deparse(substitute(Model))
  return(Model.Fit)
}



#### load data file ####
Data <- read_xlsx("Data/Biweekly monitoring.xlsx", sheet = "Processed")

Data$Field <- as.factor(Data$Field)
Data$Week <- factor(Data$Week)
Data$Total_Delia <- Data$Larvae+Data$Pupae

str(Data)

Data_long <- as.data.frame(Data %>% select(Field, Week, Larvae, Pupae))
Data_long <- gather(Data_long, key = Stage, value = count, -Field, -Week)
Data_long$Stage <- factor(Data_long$Stage)

str(Data_long)

p1 <- ggplot(Data_long, aes(x=Week, y=count, fill=Stage)) + 
  geom_bar(position = "stack", stat = "summary")+
  geom_jitter(width = 0.1, alpha = 0.4)+
  theme_bw()+
  scale_y_continuous(limits = c(0, 8), oob = scales::squish,
                     expand = expansion(mult = c(0, 0.05)))
p1
