from Quantum_Network_Architecture.simulation.runners import run_network_simulation_homogeneous_demands



# def test1():
#     run_network_simulation_homogeneous_demands('QKD', 0.003, 0, 100, 2100,
#                                                    '/home/tbeauchamp/quantum-network-architecture-simulation/configuration_files/network-configurations/6-node-alt1.yaml',
#                                                    0, None, None, True, 3600, False, False, debug=True, save_to_file=None,
#                                                    skipping_of_PGAs_permitted=False)
#
# def test_record_comp_times():
#     run_network_simulation_homogeneous_demands('QKD', 0.0015, 0, 100, 2100,
#                                                    '/home/tbeauchamp/quantum-network-architecture-simulation/configuration_files/network-configurations/6-node-alt1.yaml',
#                                                    0, None, None, True, 1500, 1800, False, False, debug=True, save_to_file=None,
#                                                    skipping_of_PGAs_permitted=False, record_computation_times_to_file="/home/tbeauchamp/quantum-network-arx-evaluation/test/comp_times.yaml")
#
# def test2():
#     run_network_simulation_homogeneous_demands('BQC', 0.0002, 0, 100, 100_000,
#                                                '/home/tbeauchamp/quantum-network-architecture-simulation/configuration_files/network-configurations/6-node-BQC.yaml',
#                                                0, [0,1,2,3,4], [5], True, 1500, 15000, 3000,False, False, debug=True, save_to_file=None
#                                                )

def test_bqc():
    run_network_simulation_homogeneous_demands(
        configs={
                'network': 'configuration_files/network-configurations/6-node-BQC.yaml',
                'sessions': 'configuration_files/session_configs/many-user-cs-BQC.yaml',
                'scheduler': 'configuration_files/scheduler_configs/scheduler_config_BQC_network.yaml',
        },
        iteration=2,
        session_renewal_rate=0.00002,
        target_packet_generation_rate=0.0005,
        simulation_length=518_400,
        debug=True,
        output_dir='/home/tbeauchamp/quantum-network-arx-evaluation/test_bqc',
        record_computation_times_to_file=False,
    )

def test_cka_lowered_util_bound():
    run_network_simulation_homogeneous_demands(
        configs={
                'network': 'configuration_files/network-configurations/6-node-BQC.yaml',
                'sessions': 'configuration_files/session_configs/many-user-cs-BQC.yaml',
                'scheduler': 'configuration_files/scheduler_configs/scheduler_config_CKA_network_lower_pgt_util_bound.yaml',
        },
        iteration=2,
        session_renewal_rate=0.00002,
        target_packet_generation_rate=0.0005,
        simulation_length=518_400,
        debug=True,
        output_dir='/home/tbeauchamp/quantum-network-arx-evaluation/test_bqc',
        record_computation_times_to_file=False,
    )
def test_qkd():
    run_network_simulation_homogeneous_demands(
        configs={
                'network': 'configuration_files/network-configurations/6-node-QKD.yaml',
                'sessions': 'configuration_files/session_configs/many-user-p2p-QKD.yaml',
                'scheduler': 'configuration_files/scheduler_configs/scheduler_config_QKD_network.yaml',
        },
        iteration=0,
        session_renewal_rate=0.002,
        target_packet_generation_rate=0.0,
        simulation_length=7200,
        debug=True,
        output_dir="/home/tbeauchamp/quantum-network-arx-evaluation/test",
        save_logs=False,
        record_computation_times_to_file=False,
        seed=8514090053624142155
    )

def test_qkd2():
    run_network_simulation_homogeneous_demands(
        configs={
                'network': 'configuration_files/network-configurations/6-node-QKD.yaml',
                'sessions': 'configuration_files/session_configs/many-user-p2p-QKD.yaml',
                'scheduler': 'configuration_files/scheduler_configs/scheduler_config_mda_network_greater_total_util_bound.yaml',
        },
        iteration=0,
        session_renewal_rate=0.00001,
        target_packet_generation_rate=0.0,
        simulation_length=21600,
        debug=True,
        output_dir="/home/tbeauchamp/quantum-network-arx-evaluation/test",
        save_logs=True,
        record_computation_times_to_file=True
    )

def test_qkd_dummy():
    run_network_simulation_homogeneous_demands(
        configs={
            'network': 'configuration_files/network-configurations/6-node-QKD.yaml',
            'sessions': 'configuration_files/session_configs/many-user-p2p-QKD.yaml',
            'scheduler': 'configuration_files/scheduler_configs/scheduler_config_QKD_network.yaml',
        },
        iteration=0,
        session_renewal_rate=0.0025,
        target_packet_generation_rate=0.2,
        simulation_length=108000,
        debug=True,
        output_dir=None,
        save_logs=False,
        record_computation_times_to_file=False,
        do_actual_scheduling=False,
        save_sessions=False
    )

def test_qkd_dummy_greater_ppacket():
    run_network_simulation_homogeneous_demands(
        configs={
            'network': 'configuration_files/network-configurations/6-node-QKD.yaml',
            'sessions': 'configuration_files/session_configs/many-user-p2p-QKD.yaml',
            'scheduler': 'configuration_files/scheduler_configs/scheduler-config-mda-lower-ppacket.yaml',
        },
        iteration=0,
        session_renewal_rate=0.0005,
        target_packet_generation_rate=0.0,
        simulation_length=108000,
        debug=True,
        output_dir=None,
        save_logs=False,
        record_computation_times_to_file=False,
        do_actual_scheduling=False,
        save_sessions=False
    )

if __name__ == '__main__':
    # test1()
    # test_record_comp_times()
    # test2()
    # test_bqc()
    test_qkd()
    # test_cka_lowered_util_bound()
    # test_qkd2()
    # test_qkd_dummy()
    # test_qkd_dummy_greater_ppacket()