import os.path

import matplotlib.pyplot as plt
import pickle

import argparse
import numpy
import numpy as np

if __name__ == '__main__':


    parser = argparse.ArgumentParser()
    parser.add_argument("data_file", type=str)
    parser.add_argument("output_directory", type=str)

    args = parser.parse_known_args()[0]

    with open(args.data_file, 'rb') as F:
        data = pickle.load(F)



    fig, ax = plt.subplots()

    ax: plt.Axes
    fig: plt.Figure

    _x, _y = zip(*data)

    ax.scatter(_x,_y)

    ax.set_xlabel("Number of PGAs scheduled")
    ax.set_ylabel("Time to compute schedule (seconds)")


    linear_regression: numpy.polynomial.Polynomial = numpy.polynomial.Polynomial.fit(_x, _y, 1)
    quadratic_regression: numpy.polynomial.Polynomial = numpy.polynomial.Polynomial.fit(_x,_y,2)

    linear_regression_to_plot = linear_regression.linspace(100, (min(_x), max(_x)))
    quadratic_regression_to_plot = quadratic_regression.linspace(100, (min(_x), max(_x)))

    # ax.plot(linear_regression_to_plot[0], linear_regression_to_plot[1], ":", label=f"linear regression")
    ax.plot(quadratic_regression_to_plot[0], quadratic_regression_to_plot[1], ':', label=f'quadratic regression', color='orange')
    ax.plot([0, max(_x)], [150, 150], ':', color='red', label='$t=150$')

    ax.set_ylim(-100,ax.get_ylim()[1])

    quadratic_regression -= 150

    roots = quadratic_regression.roots()
    print(roots)
    print(len(data))

    ax.plot([roots[1], roots[1]], [-150, 150], ':', color='black', label=f'$N={roots[1]:.0f}$')

    print((quadratic_regression+75).roots())
    print((quadratic_regression-150).roots())

    ax.legend()

    fig.show()
    fig.savefig(os.path.join(args.output_directory, "schedule computation times.png"), dpi=400)






