import argparse
import os
import pandas as pd




if __name__ == '__main__':


    parser = argparse.ArgumentParser()
    parser.add_argument('raw_data_dir', type=str, help='root directory of raw data files')

    args = parser.parse_args()

    df = None
    for root, dirs, files in os.walk(args.raw_data_dir):
        for file in files:
            if file.endswith('.pickle'):
                path = os.path.join(root, file)
                with open(path, 'rb') as f:
                    if df is None:
                        df = pd.read_pickle(f)
                    else:
                        df = pd.concat([df, pd.read_pickle(f)])

    df.sort_index(inplace=True)

    print(df)

    with open(os.path.join(args.raw_data_dir,'..','raw-data.pickle'), 'wb') as f:
        df.to_pickle(f)
    with open(os.path.join(args.raw_data_dir,'..', 'combined.csv'), 'w') as f:
        df.to_csv(f, index=True)

