# Configuration Files

There are four different types of configuration file:
- Simulation - defines the simulation parameters 
- Session - defines the application session parameters
- Scheduler - configures the network scheduler
- Network - configures the network

These are all YAML files, with formats as below.  

## Simulation Configuration

Simulation configuration YAML files have the following format:
```
configuration files:
    network: configuration_files/network-configurations/6-node-BQC.yaml
    sessions: configuration_files/session_configs/many-user-cs-BQC.yaml
    scheduler: configuration_files/scheduler_configs/scheduler_config_BQC_network.yaml
    
session rates:
    - 0.0000001
    - 0.000005
    - 0.00001
    - 0.000015
    - 0.00002
    - 0.000025

packet rates:
    - 0.0     # Calculate min rate for min service at runtime
    - 0.0005  # minimum rate for 850 PGAs
    - 0.001  # 2x min rate

simulation length: 31_104_000 # 360 days
iterations: 250

single session per flow: True 

save sessions: False
debug: False
```

## Session Configuration
```
application: CKA
minimum instances: 100
maximum demand duration: 345_600
clients:
    - 0
    - 1
    - 2
    - 3
    - 4
servers:
    - 5
```

The lists `clients`/`servers`are optional, if not provided then all end nodes will be used for that category

## Scheduler Configuration
```angular2html
scheduling interval: 300
initial cap on pgas per schedule: 1500
update cap from computation time: False
priority function: EDF
allow skipping of pgas: False
ignore resources: False
utilisation bound: 0.85
pga success probability: 0.2
```

## Network Configuration
```
number_of_satellites: 6
central_node_id: 255
number_of_qubits_per_satellite_node: 5
prob_max_mixed: 0.1
attempt_success_prob: 0.000075
attempt_duration: 100_000.0
state_delay: 9_999.0
t1: 1_000_000_000
t2: 1_000_000_000
classical_latency: 1_000_000
```

