from qoala.lang.program import QoalaProgram
from qoala.lang.parse import QoalaParser
from qoala.sim.build import build_network_from_config

import os

from Quantum_Network_Architecture.networks import HomogeneousStarNetwork

def load_program(path: str) -> QoalaProgram:
    with open(os.path.join(os.path.dirname(__file__),"qoala_files",path)) as file:
        text = file.read()
    return QoalaParser(text).parse()


DEFAULT_FOUR_NODE_STAR = HomogeneousStarNetwork(4, number_of_qubits_per_satellite_node=5, prob_max_mixed=0.1,
                                                attempt_success_prob=0.3, attempt_duration=100_000, state_delay=100_000)
DEFAULT_QOALA_NETWORK = build_network_from_config(DEFAULT_FOUR_NODE_STAR.network_config)



QKD_ALICE_PROGRAM_SINGLE_ROUND = load_program("qkd_alice.iqoala")
QKD_BOB_PROGRAM_SINGLE_ROUND = load_program("qkd_bob.iqoala")

QKD_ALICE_PROGRAM_100_BITS = load_program("qkd_100_pairs_alice.iqoala")
QKD_BOB_PROGRAM_100_BITS = load_program("qkd_100_pairs_bob.iqoala")

BQC_CLIENT_PROGRAM_100_ROUNDS = load_program("bqc_100_rounds_client.iqoala")
BQC_SERVER_PROGRAM_100_ROUNDS = load_program("bqc_100_rounds_server.iqoala")

BQC_CLIENT_PROGRAM_SINGLE_ROUND = load_program("bqc_1_round_client.iqoala")
BQC_SERVER_PROGRAM_SINGLE_ROUND = load_program("bqc_1_round_server.iqoala")










