from Quantum_Network_Architecture.tasks import PacketGenerationTask
from math import inf

def edf_priority(tsk: PacketGenerationTask, t: float) -> float:
    return 1/(tsk.next_deadline - t) if tsk.next_deadline > t else inf  # ordered by next deadline

def dropped_pga_biased_priority(tsk: PacketGenerationTask, t: float) -> float:
    return tsk.dropped_packets/(tsk.next_deadline - t)  # ordered by next deadline, then number of dropped packets

def expiry_time_priority(tsk: PacketGenerationTask, t: float) -> float:
    return 1/(tsk.expiry_time - t) if t != tsk.expiry_time else inf # ordered by time until expiry

def fifo_priority(tsk: PacketGenerationTask) -> float:
    return tsk.creation_time




