class InitialisationError(Exception):
    def __init__(self, id):
        super().__init__(f"Network Task '{id}' not initialised")


class NumberOfQubitError(Exception):
    def __init__(self, _type, n):
        super().__init__(f"Number of {_type} qubits should be an integer or infinity (provided {n})")

class ExpiryError(Exception):
    def __init__(self, n):
        super().__init__(f"Demand {n} has expired.")