import pandas as pd

# Load the Excel file
file_path = 'floods_mswep_merged.xlsx'  # Replace with your actual file path
df = pd.read_excel(file_path)

# Define a function to generate a unique key for each row based on latitude, longitude, and country_x
def generate_key(row):
    return f"{row['latitude']}_{row['longitude']}_{row['country_x']}"

# Create a unique identifier column
df['unique_key'] = df.apply(generate_key, axis=1)

# Dictionary to store the maximum values for each key
max_values = {}

# Populate the max_values dictionary with the maximums for each key (if present in the data)
for col in ['Max3h', 'Max6h', 'Max12h', 'Max24h', 'Max48h']:
    grouped = df.groupby('unique_key')[col].max()
    max_values[col] = grouped.to_dict()

# Fill missing values based on the computed maximums for each key
def fill_columns(row):
    key = row['unique_key']
    for col in ['Max3h', 'Max6h', 'Max12h', 'Max24h', 'Max48h']:
        if pd.isna(row[col]) and key in max_values[col]:
            row[col] = max_values[col][key]
    return row

# Apply the fill function to the dataframe
df = df.apply(fill_columns, axis=1)

# Drop the unique_key column (optional)
df.drop(columns=['unique_key'], inplace=True)

# Save the updated file
output_file = 'filled_floods_mswep_merged.xlsx'
df.to_excel(output_file, index=False)
print(f"Updated file saved as {output_file}")
