"""
2022-2024 Sebastian de Bone (QuTech)
https://github.com/sebastiandebone/ghz_prot_II
_____________________________________________
"""
from matplotlib import pyplot as plt
from matplotlib.mathtext import _mathtext as mathtext


def plot_fonts(style=None, fontsize=None):
    # Different options:

    # plt.rc('text', usetex=True)

    # plt.rc('font', family='cmss10')
    # plt.rc('font', family='STIXGeneral')
    # plt.rc('font', family='cmr10')
    # plt.rc('font', family='serif')

    # plt.rc('mathtext', fontset='cm')    # 'dejavusans', 'dejavuserif', 'cm', 'stix', and 'stixsans'.

    # plt.rcParams['figure.figsize'] = 8.5/2.54, 7/2.54
    # plt.rcParams["font.family"] = "Calibri"
    # plt.rcParams["font.style"] = "normal"
    # plt.rcParams["font.weight"] = "100"
    # plt.rcParams["font.stretch"] = "normal"
    # plt.rcParams["font.size"] = 12
    # plt.rcParams["lines.linewidth"] = 1
    # plt.rcParams["axes.linewidth"] = 0.3
    # plt.rcParams["grid.linewidth"] = 0.3
    # plt.rcParams.update({'figure.autolayout': True})

    if style == "dissertation":
        plt.rc('font', family='Libertinus Serif')
        plt.rc('mathtext', fontset='custom')
        plt.rc('mathtext', rm='Libertinus Math')
        plt.rc('mathtext', it='Libertinus Serif:italic')
        plt.rcParams["font.size"] = 15.06 if fontsize is None else fontsize
        # mathtext.FontConstantsBase.sup1 = 0.5
        # mathtext.FontConstantsBase.subdrop = 0.1
        # mathtext.FontConstantsBase.script_space = 0.001
    elif style == "paper":
        plt.rc('mathtext', fontset='cm')
        plt.rc('font', family='cmss10')
        plt.rcParams["font.size"] = 16 if fontsize is None else fontsize
        

def plot_settings(axes=None, style=None, number_colors=None, set_grid=True, set_minor_grid=None):
    # Different options:
    
    # plt.grid(axis='y', alpha=0.75)
    # plt.grid(axis='x', alpha=0.75)

    # ax.patch.set_facecolor('0.97')

    # ax.spines["top"].set_visible(False)
    # ax.spines["right"].set_visible(False)
    # ax.spines["bottom"].set_visible(False)
    # ax.spines["left"].set_visible(False)
    # ax.yaxis.set_major_formatter(mpl.ticker.FuncFormatter(update_ticks_y))

    axes = [plt.gca()] if axes is None else axes
    colors = {}
    if set_minor_grid is None:
        set_minor_grid = True if (style == "paper" and set_grid is True) else False

    if style == "dissertation":
        for ax in axes:
            if set_grid is True:
                ax.grid(color='0.9', linestyle='-', linewidth=1)
            # ax.tick_params(color='0.1', labelcolor='gray')
            for spine in ax.spines.values():
                spine.set_edgecolor('0.65')
            if set_minor_grid is True:
                ax.grid(which='minor', color='0.92', linestyle='-', linewidth=0.5)
        colors = {'cyaan': '#00A6D6', 'lightgreen': '#6CC24A',  'yellow': '#FFB81C', 'red': '#E03C31',
                  'purple': '#6F1D77', 'darkgreen': '#009B77', 'pink': '#EF60A3', 'blue': '#0076C2',
                  'framboos': '#A50034', 'orange': '#EC6842', 'turkoois': '#00B8C8', 'darkblue': '#6F1D77', }
    elif style == "paper":
        for ax in axes:
            if set_grid is True:
                ax.grid(color='0.85', linestyle='-', linewidth=1)
            ax.patch.set_facecolor('0.97')
            ax.spines["top"].set_visible(False)
            ax.spines["right"].set_visible(False)
            ax.spines["bottom"].set_visible(False)
            ax.spines["left"].set_visible(False)
            if set_minor_grid is True:
                ax.grid(which='minor', color='0.9', linestyle='-', linewidth=0.5)
        number_colors = 5 if number_colors is None else number_colors
        colors = {i: f"C{i%10}" for i in range(number_colors)}

    return colors