"""
2022-2024 Sébastian de Bone (QuTech)
https://github.com/sebastiandebone/ghz_prot_II/
"""
from math import sqrt, pi
import scipy.integrate as integrate
import numpy as np


def prefactor(x):
    value = 1
    if x % 2 == 0:
        value /= 2*sqrt(x)
        for y in range(2, x):
            if y % 2 == 1:
                value *= y
            else:
                value /= y
    else:
        value /= pi*sqrt(x)
        for y in range(2, x):
            if y % 2 == 0:
                value *= y
            else:
                value /= y
    return value


def closest_value(input_list, input_value):
    arr = np.asarray(input_list)
    i = (np.abs(arr - input_value)).argmin()
    return arr[i], i


def t_distribution(nu, x):
    return prefactor(nu)*(1+x**2/nu)**(-(nu+1)/2)


def find_t(p=0.95, df=30, start_t=1.5, end_t=5, number_tries=10000):
    results = []
    t_values = []
    for x in range(number_tries):
        t = start_t + x * (end_t - start_t) / number_tries
        result = integrate.quad(lambda x: t_distribution(df, x), -1 * t, t)
        results.append(result[0])
        t_values.append(t)
    clos_val, t = closest_value(results, p)
    return clos_val, t_values[t]


def calculate_confidence_interval(samples, p=0.95, start_t=1.9, end_t=5, number_tries=10000, t=None):
    average = np.average(samples)
    n = len(samples)
    error_margin = 0
    for sample in samples:
        error_margin += (sample - average) ** 2
    if t is None:
        t = find_t(p=p, df=n-1, start_t=start_t, end_t=end_t, number_tries=number_tries)[1]
    full_error_margin = t * sqrt(error_margin / (n * (n - 1))) if n > 1 else t * sqrt(error_margin / (n * n))
    return full_error_margin


if __name__ == "__main__":
    print(find_t())

